<?php

/*
 * Model's functions of TypeInformationMaladie Entity
 */

/**
 * @author Messanga Landry <messangalandry@gmail.com>
 */

include APPLICATION_PATH . '/Models/TypeInformationMaladie.php';

class TypeInformationMaladieDAO {
    //put your code here
    public $_em;
    function TypeInformationMaladieDAO(){
        $registry = Zend_Registry::getInstance();
        $this->_em = $registry->entitymanager;
    }
    
    /**
     * 
     * @param Application\Models\TypeInformationMaladie $typeInfoMaladie
     */
    public function save($typeInfoMaladie){
        $this->_em->persist($typeInfoMaladie);
        $this->_em->flush();
        
    }
    
    /**
     * 
     * @param Application\Models\TypeInformationMaladie $typeInfoMaladie
     */
    public function edit($typeInfoMaladie){
        $this->_em->merge($typeInfoMaladie);
        $this->_em->flush();
    }
    //Delete un site
    public function delete($typeInfoMaladie) {

        $this->_em->merge($typeInfoMaladie);
        $this->_em->flush();
    }
    
    // /**
    //  * 
    //  * @param Application\Models\NatureEchantillon $natEchan
    //  */
    // public function disable($fiche){
    //     $this->_em->remove($fiche);
    //     $this->_em->flush();
    // }
    
    /**
    
     * @return Application\Models\TypeInformationMaladie
     */
    public function listAll(){
           $liste =  $this->_em->getRepository("\Application\Models\TypeInformationMaladie")->findBy(array("state" => 1));
          
           return $liste;
    }
     /**
     * 
     * @param string $code
     * @return Application\Models\TypeInformationMaladie
     */
    public function getNatureEchantillonByCode($code){
        $site = $this->_em->getRepository('\Application\Models\TypeInformationMaladie')->findOneBy(array("code" => $code,"state"=>1));
        return $site;
    }
    
   
      public function findByName($name){
        $liste = $this->_em->createQueryBuilder()
                ->select('c')
                ->from("\Application\Models\TypeInformationMaladie","c")
                ->where('c.state = 1')
                ->andWhere('c.name like :name ')
                ->setParameter('name',"%".$name."%")
                ->getQuery()
                ->getResult();
       
        return $liste;
    }
  

}
