<?php

/*
 * Model's functions of Role Entity
 */

/**
 * @author Messanga Landry <messangalandry@gmail.com>
 */

include APPLICATION_PATH . '/Models/LaboratoireUtilisateur.php';

class UserLaboDAO {
    //put your code here
    public $_em;
    function UserLaboDAO(){
        $registry = Zend_Registry::getInstance();
        $this->_em = $registry->entitymanager;
    }
    
    /**
     * 
     * @param Application\Models\LaboratoireUtilisateur $userLabo
     */
    public function save($userLabo){
        $this->_em->persist($userLabo);
        $this->_em->flush();
        
    }
    
    /**
     * 
     * @param Application\Models\LaboratoireUtilisateur $userLabo
     */
    public function edit($userLabo){
        $this->_em->merge($userLabo);
        $this->_em->flush();
    }
    /**
     * 
     * @param Application\Models\LaboratoireUtilisateur $userLabo
     */
     public function delete($userLabo) {

        $this->_em->remove($userLabo);
        $this->_em->flush();
    }
   
   

     /**
        @param Application\Models\Utilisateur $user
     * @return Application\Models\LaboratoireUtilisateur
     */
    public function listUserLaboByUser($user){
           $liste =  $this->_em->getRepository("\Application\Models\LaboratoireUtilisateur")->findBy(array("utilisateur" => $user,"state"=>1));
          
           return $liste;
    }
    /**
        @param Application\Models\Laboratoire $labo
     * @return Application\Models\LaboratoireUtilisateur
     */
    public function listUserLaboByLabo($labo){
           $liste =  $this->_em->getRepository("\Application\Models\LaboratoireUtilisateur")->findBy(array("laboratoire" => $labo,"state"=>1));
          
           return $liste;
    }
    public function getUserLaboByCode($code){
        $userLabo = $this->_em->getRepository('\Application\Models\LaboratoireUtilisateur')->findOneBy(array("code" => $code,"state"=>1));
        return $userLabo;
    }
     public function roleAuth($user, $labo){ //dit si le profil a droit au menu
        $listUserLabos = $this->_em->getRepository('\Application\Models\LaboratoireUtilisateur')
                ->findBy(array('utilisateur' => $user,'laboratoire' =>$labo,"state"=>1));
        if(is_array($listUserLabos) && !empty($listUserLabos) ) return true;   
        else return false;
    }
    
   
   
}
