<?php

/*
 * Model's functions of Role Entity
 */

/**
 * @author Messanga Landry <messangalandry@gmail.com>
 */

include APPLICATION_PATH . '/Models/SiteUtilisateur.php';

class UserSiteDAO {
    //put your code here
    public $_em;
    function UserLaboDAO(){
        $registry = Zend_Registry::getInstance();
        $this->_em = $registry->entitymanager;
    }
    
    /**
     * 
     * @param Application\Models\SiteUtilisateur $userSite
     */
    public function save($userSite){
        $this->_em->persist($userSite);
        $this->_em->flush();
        
    }
    
    /**
     * 
     * @param Application\Models\SiteUtilisateur $userSite
     */
    public function edit($userSite){
        $this->_em->merge($userSite);
        $this->_em->flush();
    }
    /**
     * 
     * @param Application\Models\SiteUtilisateur $userSite
     */
     public function delete($userSite) {

        $this->_em->remove($userSite);
        $this->_em->flush();
    }
   
   

     /**
        @param Application\Models\Utilisateur $user
     * @return Application\Models\SiteUtilisateur
     */
    public function listUserSiteByUser($user){
           $liste =  $this->_em->getRepository("\Application\Models\SiteUtilisateur")->findBy(array("utilisateur" => $user,"state"=>1));
          
           return $liste;
    }
    /**
        @param Application\Models\Site $site
     * @return Application\Models\SiteUtilisateur
     */
    public function listUserSiteBySite($site){
           $liste =  $this->_em->getRepository("\Application\Models\SiteUtilisateur")->findBy(array("site" => $labo,"state"=>1));
          
           return $liste;
    }
    public function getUserSiteByCode($code){
        $userLabo = $this->_em->getRepository('\Application\Models\SiteUtilisateur')->findOneBy(array("code" => $code,"state"=>1));
        return $userLabo;
    }
     public function roleAuth($user, $labo){ //dit si le profil a droit au menu
        $listUserSites= $this->_em->getRepository('\Application\Models\SiteUtilisateur')
                ->findBy(array('utilisateur' => $user,'site' =>$labo,"state"=>1));
        if(is_array($listUserSites) && !empty($listUserSites) ) return true;   
        else return false;
    }
    
   
   
}
