<?php

/*
 * Model's function for Personne Entity
 */

/**
 * @author Messanga Landry <messangalandry@gmail.com>
 */

include  APPLICATION_PATH. '/Models/Utilisateur.php';

class UtilisateurDAO {
    //put your code here
    public $_em;
    
    function UtilisateurDAO(){
        $registry = Zend_Registry::getInstance();
        $this->_em = $registry->entitymanager;
    }
    
    /**
     * 
     * @param Application\Models\Utilisateur $utilisateur
     */
    public function save($utilisateur){
         
        $this->_em->persist($utilisateur);
        $this->_em->flush();
    }
    
    /**
     * 
     * @param Application\Models\Utilisateur $utilisateur
     */
    public function edit($utilisateur){
        
        $this->_em->merge($utilisateur);
        $this->_em->flush();
    }
    
    /**
     * 
     * @param Application\Models\Utilisateur $utilisateur
     */
    public function delete($utilisateur){
        $utilisateur->setState(0);
        $this->_em->merge($utilisateur);
        $this->_em->flush();
    }
    
    /**
     * 
     * @param integer $code
     * @return Application\Models\Utilisateur
     */
    public function getUtilisateurByCode($code){
        
        $user = $this->_em->getRepository('\Application\Models\Utilisateur')->findOneBy(array('code' => $code, "state" => 1));  
        return $user;
    }
     /**
     * 
     * @param String $login
     * @return Application\Models\Utilisateur
     */
    public function getUtilisateurByLogin($login){
        $listUser  = $this->_em->getRepository('\Application\Models\Utilisateur')->findBy(array("login" => $login , "state" => 1));
        
        return $listUser;
    }
    
  /**
     * 
     * @param String $login
     * @param String $password
     * @return Application\Models\Utilisateur
     */
    public function getUtilisateurLoginPassword($login , $password){
           $user =  $this->_em->getRepository("\Application\Models\Utilisateur")->findOneBy(array('login' => $login , 'password' => $password, "state" => 1));
         
           if ( $user ){
               return $user;
           }else{
               return null;
           }
    }
    
     /**
    
     * @return Application\Models\Utilisateur
     */
    public function listAll(){
           $liste =  $this->_em->getRepository("\Application\Models\Utilisateur")->findBy(array("statut" => 1));
          
           return $liste;
    }

    
    
   
    
	
}

