<?php

namespace Application\Models;

use Doctrine\ORM\Mapping as ORM;

/**
 * Authorisation
 *
 * @ORM\Table(name="authorisation")
 * @ORM\Entity
 */
class Authorisation
{
    /**
     * @var string
     *
     * @ORM\Column(name="CODE", type="string", length=50, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $code;

    /**
     * @var string
     *
     * @ORM\Column(name="LABEL", type="string", length=50, nullable=true)
     */
    private $label;

    /**
     * @var string
     *
     * @ORM\Column(name="ACTION", type="string", length=50, nullable=true)
     */
    private $action;

    /**
     * @var string
     *
     * @ORM\Column(name="CONTROLEUR", type="string", length=50, nullable=true)
     */
    private $controleur;

    /**
     * @var integer
     *
     * @ORM\Column(name="STATE", type="smallint", nullable=true)
     */
    private $state;

    /**
     * @var \Application\Models\Authorisation
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Authorisation")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="PARENT", referencedColumnName="CODE")
     * })
     */
    private $parent;

    /**
     * @var integer
     *
     * @ORM\Column(name="ORDRE", type="smallint", nullable=true)
     */
    private $ordre;
    
    /**
     * @var string
     *
     * @ORM\Column(name="ICON", type="string", length=60, nullable=true)
     */
    private $icon;

    /**
     * Get code
     *
     * @return string 
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set label
     *
     * @param string $label
     * @return Authorisation
     */
    public function setLabel($label)
    {
        $this->label = $label;
    
        return $this;
    }

    /**
     * Get label
     *
     * @return string 
     */
    public function getLabel()
    {
        return $this->label;
    }

    /**
     * Set action
     *
     * @param string $action
     * @return Authorisation
     */
    public function setAction($action)
    {
        $this->action = $action;
    
        return $this;
    }

    /**
     * Get action
     *
     * @return string 
     */
    public function getAction()
    {
        return $this->action;
    }

    /**
     * Set controleur
     *
     * @param string $controleur
     * @return Authorisation
     */
    public function setControleur($controleur)
    {
        $this->controleur = $controleur;
    
        return $this;
    }

    /**
     * Get controleur
     *
     * @return string 
     */
    public function getControleur()
    {
        return $this->controleur;
    }
    
     /**
     * Set icon
     *
     * @param string $icon
     * @return Authorisation
     */
    public function setIcon($icon)
    {
        $this->icon = $icon;
    
        return $this;
    }

    /**
     * Get icon
     *
     * @return string 
     */
    public function getIcon()
    {
        return $this->icon;
    }

    /**
     * Set state
     *
     * @param integer $state
     * @return Authorisation
     */
    public function setState($state)
    {
        $this->state = $state;
    
        return $this;
    }

     /* * Set ordre
     *
     * @param integer $ordre
     * @return Authorisation
     */
    public function setOrdre($ordre)
    {
        $this->ordre = $ordre;
    
        return $this;
    }

    /**
     * Get state
     *
     * @return integer 
     */
    public function getState()
    {
        return $this->state;
    }

     /**
     * Get ordre
     *
     * @return integer 
     */
    public function getOrdre()
    {
        return $this->ordre;
    }
     /**
     * Set parent
     *
     * @param \Application\Models\Authorisation $parent
     * @return Authorisation
     */
    public function setParent(\Application\Models\Authorisation $parent = null)
    {
        $this->parent = $parent;
    
        return $this;
    }

    /**
     * Get parent
     *
     * @return \Application\Models\Authorisation 
     */
    public function getParent()
    {
        return $this->parent;
    }
}