<?php

namespace Application\Models;

use Doctrine\ORM\Mapping as ORM;

/**
 * DemandeTest
 *
 * @ORM\Table(name="demande_test")
 * @ORM\Entity
 */
class DemandeTest
{
    /**
     * @var string
     *
     * @ORM\Column(name="CODE", type="string", length=50, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $code;

    /**
     * @var string
     *
     * @ORM\Column(name="UTILISATEUR", type="string", length=50, nullable=true)
     */
    private $utilisateur;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="DATEDEMANDE", type="datetime", nullable=true)
     */
    private $datedemande;

    /**
     * @var integer
     *
     * @ORM\Column(name="STATE", type="smallint", nullable=true)
     */
    private $state;

    /**
     * @var \Application\Models\Echantillon
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Echantillon")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="ECHANTILLON", referencedColumnName="CODE")
     * })
     */
    private $echantillon;

    /**
     * @var \Application\Models\MaladieTypeTest
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\MaladieTypeTest")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="MALADIE_TYPE_TEST", referencedColumnName="CODE")
     * })
     */
    private $maladieTypeTest;

    /**
     * @var \Application\Models\Patient
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Patient")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="PATIENT", referencedColumnName="CODE")
     * })
     */
    private $patient;

    /**
     * @var \Application\Models\Resultat
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Resultat")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="RESULTAT", referencedColumnName="CODE")
     * })
     */
    private $resultat;



    /**
     * Get code
     *
     * @return string 
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set utilisateur
     *
     * @param string $utilisateur
     * @return DemandeTest
     */
    public function setUtilisateur($utilisateur)
    {
        $this->utilisateur = $utilisateur;
    
        return $this;
    }

    /**
     * Get utilisateur
     *
     * @return string 
     */
    public function getUtilisateur()
    {
        return $this->utilisateur;
    }

    /**
     * Set datedemande
     *
     * @param \DateTime $datedemande
     * @return DemandeTest
     */
    public function setDatedemande($datedemande)
    {
        $this->datedemande = $datedemande;
    
        return $this;
    }

    /**
     * Get datedemande
     *
     * @return \DateTime 
     */
    public function getDatedemande()
    {
        return $this->datedemande;
    }

    /**
     * Set state
     *
     * @param integer $state
     * @return DemandeTest
     */
    public function setState($state)
    {
        $this->state = $state;
    
        return $this;
    }

    /**
     * Get state
     *
     * @return integer 
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Set echantillon
     *
     * @param \Application\Models\Echantillon $echantillon
     * @return DemandeTest
     */
    public function setEchantillon(\Application\Models\Echantillon $echantillon = null)
    {
        $this->echantillon = $echantillon;
    
        return $this;
    }

    /**
     * Get echantillon
     *
     * @return \Application\Models\Echantillon 
     */
    public function getEchantillon()
    {
        return $this->echantillon;
    }

    /**
     * Set maladieTypeTest
     *
     * @param \Application\Models\MaladieTypeTest $maladieTypeTest
     * @return DemandeTest
     */
    public function setMaladieTypeTest(\Application\Models\MaladieTypeTest $maladieTypeTest = null)
    {
        $this->maladieTypeTest = $maladieTypeTest;
    
        return $this;
    }

    /**
     * Get maladieTypeTest
     *
     * @return \Application\Models\MaladieTypeTest 
     */
    public function getMaladieTypeTest()
    {
        return $this->maladieTypeTest;
    }

    /**
     * Set patient
     *
     * @param \Application\Models\Patient $patient
     * @return DemandeTest
     */
    public function setPatient(\Application\Models\Patient $patient = null)
    {
        $this->patient = $patient;
    
        return $this;
    }

    /**
     * Get patient
     *
     * @return \Application\Models\Patient 
     */
    public function getPatient()
    {
        return $this->patient;
    }

    /**
     * Set resultat
     *
     * @param \Application\Models\Resultat $resultat
     * @return DemandeTest
     */
    public function setResultat(\Application\Models\Resultat $resultat = null)
    {
        $this->resultat = $resultat;
    
        return $this;
    }

    /**
     * Get resultat
     *
     * @return \Application\Models\Resultat 
     */
    public function getResultat()
    {
        return $this->resultat;
    }
}