<?php

namespace Application\Models;

use Doctrine\ORM\Mapping as ORM;

/**
 * InformationMaladieOption
 *
 * @ORM\Table(name="information_maladie_option")
 * @ORM\Entity
 */
class InformationMaladieOption
{
    /**
     * @var string
     *
     * @ORM\Column(name="CODE", type="string", length=50, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $code;

    /**
     * @var integer
     *
     * @ORM\Column(name="STATE", type="smallint", nullable=true)
     */
    private $state;

    /**
     * @var \Application\Models\InformationMaladie
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\InformationMaladie")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="INFORMATIONMALADIE", referencedColumnName="CODE")
     * })
     */
    private $informationmaladie;

    /**
     * @var \Application\Models\Options
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Options")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="OPTIONS", referencedColumnName="CODE")
     * })
     */
    private $options;



    /**
     * Get code
     *
     * @return string 
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set state
     *
     * @param integer $state
     * @return InformationMaladieOption
     */
    public function setState($state)
    {
        $this->state = $state;
    
        return $this;
    }

    /**
     * Get state
     *
     * @return integer 
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Set informationmaladie
     *
     * @param \Application\Models\InformationMaladie $informationmaladie
     * @return InformationMaladieOption
     */
    public function setInformationmaladie(\Application\Models\InformationMaladie $informationmaladie = null)
    {
        $this->informationmaladie = $informationmaladie;
    
        return $this;
    }

    /**
     * Get informationmaladie
     *
     * @return \Application\Models\InformationMaladie 
     */
    public function getInformationmaladie()
    {
        return $this->informationmaladie;
    }

    /**
     * Set options
     *
     * @param \Application\Models\Options $options
     * @return InformationMaladieOption
     */
    public function setOptions(\Application\Models\Options $options = null)
    {
        $this->options = $options;
    
        return $this;
    }

    /**
     * Get options
     *
     * @return \Application\Models\Options 
     */
    public function getOptions()
    {
        return $this->options;
    }
}