<?php

include APPLICATION_PATH . '/DAO/UtilisateurDAO.php';
include APPLICATION_PATH . '/DAO/RoleDAO.php';
include APPLICATION_PATH . '/DAO/RoleAuthorisationDAO.php';
include APPLICATION_PATH . '/DAO/AuthorisationDAO.php';
include APPLICATION_PATH . '/DAO/LogDAO.php';
include PUBLIC_PATH.'/Fonctions/Fonction.php';
include PUBLIC_PATH . '/files_to_include/Constantes.php';
include APPLICATION_PATH .'/DAO/Osms.php';

abstract class API_Controller extends Zend_Rest_Controller
{
 public function headAction()
  {
    // you should add your own logic here to check for cache headers from the request
    $this->getResponse()->setBody(null);
  }

  public function optionsAction()
  {
    $this->getResponse()->setBody(null);
    $this->getResponse()->setHeader('Allow', 'OPTIONS, HEAD, INDEX, GET, POST, PUT, DELETE');
  }
}

class ApiController extends  API_Controller

{

  
 

    public function init(){
    $bootstrap = $this->getInvokeArg('bootstrap');
    //$options = $bootstrap->getOption('resources');

    $contextSwitch = $this->_helper->getHelper('contextSwitch');
    $contextSwitch  ->addActionContext('index', array('json'))
                    ->addActionContext('get', array("json"))
                    ->addActionContext('post', array("json"))
                    ->addActionContext('put', array("json"))
                    ->addActionContext('delete', array("json"))
                    ->initContext('json');
}
   

public function deleteAction() {
        $this->view->retour = "deleteAction";
    }

    public function getAction() {
        $this->view->retour = "getAction";
    }

    public function indexAction() {
        $start = $_GET['start'] ?? '2021-06-01';
        $end = $_GET['end'] ?? date("Y-m-d");
        $table = 'covid';
        ini_set('memory_limit', '512M');

        $primaryKey = 'level_0';
        $columns = array(
            array('db' => 'EPI_ID' , 'dt' => 0),
            array('db' => 'NOM' , 'dt' => 1),
             array('db' => 'CODE_PATIENT' , 'dt' => 2),
             array('db' => 'AGE' , 'dt' => 3),
             array('db' => 'SEXE' , 'dt' => 4),
             array('db' => 'TEL' , 'dt' => 5),
             array('db' => 'LIEU_DE_PRELEVEMENT' , 'dt' => 6),
             array('db' => 'DD_SYMPTOMES' , 'dt' => 7),
             array('db' => 'DATE_PRLVT' , 'dt' => 8),
             array('db' => 'CONCLUSION' , 'dt' => 9),
             array('db' => 'DATE_RENDU' , 'dt' => 10),
             array('db' => 'Unites' , 'dt' => 11),
             array('db' => 'CODE_RESULTAT' , 'dt' => 12)
        );


        $sql_details = array(
            'user' => DB_USER,
            'pass' => DB_PASSWORD,
            'db' => DB_NAME,
            'host' => HOSTNAME
        );
        require(PUBLIC_PATH . '/files_to_include/ssp.class.php');
        try {
            // Try Connect to the DB with new MySqli object - Params {hostname, userid, password, dbname}
            $mysqli = new mysqli(HOSTNAME, DB_USER, DB_PASSWORD, DB_NAME);

            //echo $start;
            $statement = $mysqli->prepare('SELECT * FROM covid WHERE STR_TO_DATE(dateSaisie,"%Y-%m-%d") between STR_TO_DATE("'.$start.'","%Y-%m-%d %H:%M:%S") and STR_TO_DATE("'.$end.'","%Y-%m-%d %H:%M:%S") limit 50');
            


            $statement->execute(); // Execute the statement.
            $result = $statement->get_result(); // Binds the last executed statement as a result.
            //echo memory_get_usage();

            $this->view->retour = $result->fetch_all(MYSQLI_ASSOC); // Parse to JSON and print.
  
        } catch (mysqli_sql_exception $e) { // Failed to connect? Lets see the exception details..
            echo "MySQLi Error Code: " . $e->getCode() . "<br />";
            echo "Exception Msg: " . $e->getMessage();
            exit(); // exit and close connection.
        }

        $mysqli->close();

        
    }

    public function postAction() {
        $this->view->retour = "postAction";
    }

    public function putAction() {
        $this->view->retour = "putAction";
    }


  

}



