<?php
include APPLICATION_PATH . '/DAO/UtilisateurDAO.php';
include APPLICATION_PATH . '/DAO/PersonneDAO.php';
include APPLICATION_PATH . '/DAO/ProfilDAO.php';
include APPLICATION_PATH . '/DAO/LogDAO.php';
include APPLICATION_PATH . '/DAO/TypeDAO.php';
include PUBLIC_PATH.'/Fonctions/Fonction.php';
include PUBLIC_PATH . '/files_to_include/Constantes.php';

class ParametreController extends Zend_Controller_Action
{

    public function init()
    {
       session_start();
        if ( isset($_SESSION["idUtilisateur"])){
            $_SESSION["derniereAction"] = new \DateTime();
            $utilisateurDao = new UtilisateurDAO();
            $this->user = $utilisateurDao->getUtilisateur((int)$_SESSION["idUtilisateur"]);
        }else{
            $this->_helper->redirector('index' , 'Index');
        }
    }

    public function indexAction()
    {
        if ( !empty($_POST)){
            $chaineTypes = "";
            $listeTypesNonStockes = json_decode(str_replace("\\","",$_POST["LISTE_TYPES_NON_STOCKES"]), true);
           
            $i = 0;
            foreach( $listeTypesNonStockes as $idType ){
                if ( $i == 0){
                    $chaineTypes .= $idType;
                }else{
                    $chaineTypes .= " " . $idType;
                }
                $i++;
                
            }
            try{
                $parametreDao = new ParametreDAO();
                $comportement_livraison_commande = $parametreDao->getParametreParNom("COMPORTEMENT_LIVRAISON_COMMANDE");
                $couleur_facture_reglee = $parametreDao->getParametreParNom("COULEUR_FACTURE_REGLEE");
                $couleur_facture_en_cours_reglement = $parametreDao->getParametreParNom("COULEUR_FACTURE_EN_COURS_REGLEMENT");
                $type_affichage_chart = $parametreDao->getParametreParNom("TYPE_AFFICHAGE_CHART");
                $couleur_facture_sans_paiement = $parametreDao->getParametreParNom("COULEUR_FACTURE_SANS_PAIEMENT");
                $couleur_commande_facturee = $parametreDao->getParametreParNom("COULEUR_COMMANDE_FACTUREE");
                $couleur_commande_non_facturee = $parametreDao->getParametreParNom("COULEUR_COMMANDE_NON_FACTUREE");
                $nom_structure = $parametreDao->getParametreParNom("NOM_STRUCTURE");
                $couleur_facture_derivee_commande = $parametreDao->getParametreParNom("COULEUR_FACTURE_DERIVEE_COMMANDE");
                $bp_structure = $parametreDao->getParametreParNom("BP_STRUCTURE");
                $tel_structure = $parametreDao->getParametreParNom("TEL_STRUCTURE");
                $email_structure = $parametreDao->getParametreParNom("EMAIL_STRUCTURE");
                $siteweb_structure = $parametreDao->getParametreParNom("SITEWEB_STRUCTURE");
                $caissier_principal = $parametreDao->getParametreParNom("CAISSIER_PRINCIPAL");
                $liste_types_non_stockes = $parametreDao->getParametreParNom("LISTE_TYPES_NON_STOCKES");
                $type_impression = $parametreDao->getParametreParNom("TYPE_IMPRESSION");
                
                if ( isset($_FILES["LOGO_STRUCTURE"]) && $_FILES["LOGO_STRUCTURE"]["name"]!=""){
                    $logo_structure = $parametreDao->getParametreParNom("LOGO_STRUCTURE");
                    $logo_structure->setValeur($_FILES["LOGO_STRUCTURE"]["name"]);
                    move_uploaded_file($_FILES['LOGO_STRUCTURE']['tmp_name'], PUBLIC_PATH . "/img/" . $_FILES['LOGO_STRUCTURE']['name'] );
                    $parametreDao->editer($logo_structure);
                }
                $comportement_livraison_commande->setValeur($_POST["COMPORTEMENT_LIVRAISON_COMMANDE"]);
                $couleur_facture_reglee->setValeur($_POST["COULEUR_FACTURE_REGLEE"]);
                $couleur_facture_en_cours_reglement->setValeur($_POST["COULEUR_FACTURE_EN_COURS_REGLEMENT"]);
                $type_affichage_chart->setValeur($_POST["TYPE_AFFICHAGE_CHART"]);
                $couleur_facture_sans_paiement->setValeur($_POST["COULEUR_FACTURE_SANS_PAIEMENT"]);
                $couleur_commande_facturee->setValeur($_POST["COULEUR_COMMANDE_FACTUREE"]);
                $couleur_commande_non_facturee->setValeur($_POST["COULEUR_COMMANDE_NON_FACTUREE"]);
                $nom_structure->setValeur($_POST["NOM_STRUCTURE"]);
                $couleur_facture_derivee_commande->setValeur($_POST["COULEUR_FACTURE_DERIVEE_COMMANDE"]);
                $bp_structure->setValeur($_POST["BP_STRUCTURE"]);
                $tel_structure->setValeur($_POST["TEL_STRUCTURE"]);
                $email_structure->setValeur($_POST["EMAIL_STRUCTURE"]);
                $siteweb_structure->setValeur($_POST["SITEWEB_STRUCTURE"]);
                $caissier_principal->setValeur($_POST["CAISSIER_PRINCIPAL"]);
                $liste_types_non_stockes->setValeur($chaineTypes);
                $type_impression->setValeur($_POST["TYPE_IMPRESSION"]);
                
                $parametreDao->editer($comportement_livraison_commande);
                $parametreDao->editer($couleur_facture_reglee);
                $parametreDao->editer($couleur_facture_en_cours_reglement);
                $parametreDao->editer($type_affichage_chart);
                $parametreDao->editer($couleur_facture_sans_paiement);
                $parametreDao->editer($couleur_commande_facturee);
                $parametreDao->editer($couleur_commande_non_facturee);
                $parametreDao->editer($nom_structure);
                $parametreDao->editer($couleur_facture_derivee_commande);
                $parametreDao->editer($bp_structure);
                $parametreDao->editer($tel_structure);
                $parametreDao->editer($email_structure);
                $parametreDao->editer($siteweb_structure);
                $parametreDao->editer($caissier_principal);
//                $parametreDao->editer($liste_types_non_stockes);
                $parametreDao->editer($type_impression);
                
                echo json_encode(array("type" => "success"));
                    //Module de capture des log pour journal des opérations.
                try {
                    $f = new Fonction();
                    $descr = "Edition/modification des parametres " ;
                    
                    $descr .= " par l'utilisateur ".utf8_encode($this->user->getIdPersonne()->getNom())." ".utf8_encode($this->user->getIdPersonne()->getPrenom())."";
                    
                    $user = $this->user;
                    
                    if ($f->EnregistrerLog($descr, $user))  ;
                    else {
                        
                    }
                } catch (Exception $exc) {
                    
                }
            } catch (Exception $ex) {
                echo json_encode(array("type" => "error"));
            }
            exit();
        }
        
        $typeDao = new TypeDAO();
        $typeDejaCoches = explode(" ", LISTE_TYPES_NON_STOCKES);
        $this->view->typeDejaCoches = json_encode($typeDejaCoches);
        $this->view->listeTypes = $typeDao->listerType();
        $userDAO = new UtilisateurDAO();
        $listeUser = $userDAO->listerUtilisateur();
        $this->view->listeUtilisateur = $listeUser;
    }


}

