<?php

/*
 * Model's functions of Site Entity
 */

/**
 * @author Messanga Landry <messangalandry@gmail.com>
 */

include APPLICATION_PATH . '/Models/Laboratoire.php';

class LaboDAO {
    //put your code here
    public $_em;
    function LaboDAO(){
        $registry = Zend_Registry::getInstance();
        $this->_em = $registry->entitymanager;
    }
    
    /**
     * 
     * @param Application\Models\Laboratoire $labo
     */
    public function save($labo){
        $this->_em->persist($labo);
        $this->_em->flush();
        
    }
    
    /**
     * 
     * @param Application\Models\Laboratoire $labo
     */
    public function edit($labo){
        $this->_em->merge($labo);
        $this->_em->flush();
    }
    //Delete un site
    public function delete($labo) {

        $this->_em->merge($labo);
        $this->_em->flush();
    }
    
    
    
    /**
    
     * @return Application\Models\Laboratoire
     */
    public function listAll(){
           $liste =  $this->_em->getRepository("\Application\Models\Laboratoire")->findBy(array("state" => 1));
          
           return $liste;
    }
     /**
     * 
     * @param string $code
     * @return Application\Models\Laboratoire
     */
    public function getLaboByCode($code){
        $site = $this->_em->getRepository('\Application\Models\Laboratoire')->findOneBy(array("code" => $code,"state"=>1));
        return $site;
    }
    
    public function existLaboName($name){

           try{
            
            $liste = $this->_em->getRepository("\Application\Models\Laboratoire")->createQueryBuilder("a")
                             ->where("UPPER(a.nom) = :name")
                             ->setParameter("name" , '%'.strtoupper($name) . '%')
                             ->andWhere("a.state=1")
                             ->getQuery()
                             ->getResult();
            
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }
         
        
        if(count($liste)>0 && is_array($liste) )return true;
        else return false;
    }
      public function findByName($name){
         
        $liste = $this->_em->createQueryBuilder()
                ->select('c')
                ->from("\Application\Models\Laboratoire","c")
                ->where('c.state = 1')
                ->andWhere('c.nom like :name ')
                ->setParameter('name',"%".$name."%")
                ->getQuery()
                ->getResult();
       
        return $liste;
    }
   
}
