<?php

/*
 * Model's functions of Role Entity
 */

/**
 * @author Messanga Landry <messangalandry@gmail.com>
 */

include APPLICATION_PATH . '/Models/RoleAuthorisation.php';

class RoleAuthorisationDAO {
    //put your code here
    public $_em;
    function RoleAuthorisationDAO(){
        $registry = Zend_Registry::getInstance();
        $this->_em = $registry->entitymanager;
    }
    
    /**
     * 
     * @param Application\Models\RoleAuthorisation $roleauthorisation
     */
    public function save($roleauthorisation){
        $this->_em->persist($roleauthorisation);
        $this->_em->flush();
        
    }
    
    /**
     * 
     * @param Application\Models\RoleAuthorisation $roleuthorisation
     */
    public function edit($roleauthorisation){
        $this->_em->merge($roleauthorisation);
        $this->_em->flush();
    }
    /**
     * 
     * @param Application\Models\RoleAuthorisation $roleuthorisation
     */
     public function delete($roleAuth) {

        $this->_em->remove($roleAuth);
        $this->_em->flush();
    }
   
   

     /**
        @param Application\Models\Role $role
     * @return Application\Models\RoleAuthorisation
     */
    public function listRoleAuthorisationByAuthorisation($authorisation){
           $liste =  $this->_em->getRepository("\Application\Models\RoleAuthorisation")->findBy(array("authorisation" => $authorisation,"statut"=>1));
          
           return $liste;
    }
    public function getRoleAuthorisationByCode($code){
        $roleuthorisation = $this->_em->getRepository('\Application\Models\RoleAuthorisation')->findOneBy(array("code" => $code,"state"=>1));
        return $roleuthorisation;
    }
     public function roleAuth($role, $auth){ //dit si le profil a droit au menu
        $droit = $this->_em->getRepository('\Application\Models\RoleAuthorisation')
                ->findBy(array('authorisation' => $auth,'role' =>$role,"state"=>1));
        if(is_array($droit) && !empty($droit) ) return true;   
        else return false;
    }
    
     public function getRoleAuthorisationByRole($role){ //dit si le profil a droit au menu
        $listRoleAuth = $this->_em->getRepository('\Application\Models\RoleAuthorisation')
                ->findBy(array('role' =>$role,"state"=>1));
         return $listRoleAuth;
    }
    public function existController($role,$controlleur){ 
        $listRoleAuth = $this->_em->getRepository('\Application\Models\RoleAuthorisation')
                ->findBy(array('role' =>$role,"state"=>1));
        $result = false;
        foreach($listRoleAuth as $elem){
                    if ($elem->getAuthorisation()->getControleur()==$controlleur){
                          $result= true;
                     }
                  }
         return $result;
    }
     /**
        @param Application\Models\Role $role
     * @return Application\Models\RoleAuthorisation
     */
    public function listRoleAuthorisationByRole($role){
           $liste =  $this->_em->getRepository("\Application\Models\RoleAuthorisation")->findBy(array("role"=>$role,"state"=>1));
          
           return $liste;
    }
   
}
