<?php

/*
 * Model's functions of Role Entity
 */

/**
 * @author Messanga Landry <messangalandry@gmail.com>
 */

include APPLICATION_PATH . '/Models/Role.php';

class RoleDAO {
    //put your code here
    public $_em;
    function RoleDAO(){
        $registry = Zend_Registry::getInstance();
        $this->_em = $registry->entitymanager;
    }
    
    /**
     * 
     * @param Application\Models\Role $role
     */
    public function save($role){
        $this->_em->persist($role);
        $this->_em->flush();
        
    }
    
    /**
     * 
     * @param Application\Models\Role $role
     */
    public function edit($role){
        $this->_em->merge($role);
        $this->_em->flush();
    }
    //Delete un log
    public function delete($role) {

        $this->_em->merge($role);
        $this->_em->flush();
    }
    
    // /**
    //  * 
    //  * @param Application\Models\Role $fiche
    //  */
    // public function disable($fiche){
    //     $this->_em->remove($fiche);
    //     $this->_em->flush();
    // }
    
    /**
    
     * @return Application\Models\Role
     */
    public function listAll(){
           $liste =  $this->_em->getRepository("\Application\Models\Role")->findBy(array("state" => 1));
          
           return $liste;
    }
     /**
     * 
     * @param string $code
     * @return Application\Models\Role
     */
    public function getRoleByCode($code){
        $role = $this->_em->getRepository('\Application\Models\Role')->findOneBy(array("code" => $code,"state"=>1));
        return $role;
    }
    
    public function existProfilName($label){

           try{
            
            $liste = $this->_em->getRepository("\Application\Models\Role")->createQueryBuilder("a")
                             ->where("UPPER(a.label) like :label")
                             ->setParameter("label" , '%'.strtoupper($label) . '%')
                             ->andWhere("a.state=1")
                             ->getQuery()
                             ->getResult();
             if(count($liste)>0 && is_array($liste) )return true;
        else return false;
        } catch (Exception $ex) {
            echo $ex->getMessage();
            
        }
         
        exit();
       
    }
   
}
