<?php

namespace Application\Models;

use Doctrine\ORM\Mapping as ORM;

/**
 * MaladieTypeTest
 *
 * @ORM\Table(name="maladie_type_test")
 * @ORM\Entity
 */
class MaladieTypeTest
{
    /**
     * @var string
     *
     * @ORM\Column(name="CODE", type="string", length=50, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $code;

    /**
     * @var integer
     *
     * @ORM\Column(name="STATE", type="smallint", nullable=true)
     */
    private $state;

    /**
     * @var \Application\Models\TypeTest
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\TypeTest")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="TYPETEST", referencedColumnName="CODE")
     * })
     */
    private $typetest;

    /**
     * @var \Application\Models\Maladie
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Maladie")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="MALADIE", referencedColumnName="CODE")
     * })
     */
    private $maladie;



    /**
     * Get code
     *
     * @return string 
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set state
     *
     * @param integer $state
     * @return MaladieTypeTest
     */
    public function setState($state)
    {
        $this->state = $state;
    
        return $this;
    }

    /**
     * Get state
     *
     * @return integer 
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Set typetest
     *
     * @param \Application\Models\TypeTest $typetest
     * @return MaladieTypeTest
     */
    public function setTypetest(\Application\Models\TypeTest $typetest = null)
    {
        $this->typetest = $typetest;
    
        return $this;
    }

    /**
     * Get typetest
     *
     * @return \Application\Models\TypeTest 
     */
    public function getTypetest()
    {
        return $this->typetest;
    }

    /**
     * Set maladie
     *
     * @param \Application\Models\Maladie $maladie
     * @return MaladieTypeTest
     */
    public function setMaladie(\Application\Models\Maladie $maladie = null)
    {
        $this->maladie = $maladie;
    
        return $this;
    }

    /**
     * Get maladie
     *
     * @return \Application\Models\Maladie 
     */
    public function getMaladie()
    {
        return $this->maladie;
    }
}