<?php

namespace Application\Models;

use Doctrine\ORM\Mapping as ORM;

/**
 * RoleAuthorisation
 *
 * @ORM\Table(name="role_authorisation")
 * @ORM\Entity
 */
class RoleAuthorisation
{
    /**
     * @var string
     *
     * @ORM\Column(name="CODE", type="string", length=50, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $code;

    /**
     * @var integer
     *
     * @ORM\Column(name="STATE", type="smallint", nullable=true)
     */
    private $state;

    /**
     * @var \Application\Models\Authorisation
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Authorisation")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="AUTHORISATION", referencedColumnName="CODE")
     * })
     */
    private $authorisation;

    /**
     * @var \Application\Models\Role
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Role")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="ROLE", referencedColumnName="CODE")
     * })
     */
    private $role;



    /**
     * Get code
     *
     * @return string 
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set state
     *
     * @param integer $state
     * @return RoleAuthorisation
     */
    public function setState($state)
    {
        $this->state = $state;
    
        return $this;
    }

    /**
     * Get state
     *
     * @return integer 
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Set authorisation
     *
     * @param \Application\Models\Authorisation $authorisation
     * @return RoleAuthorisation
     */
    public function setAuthorisation(\Application\Models\Authorisation $authorisation = null)
    {
        $this->authorisation = $authorisation;
    
        return $this;
    }

    /**
     * Get authorisation
     *
     * @return \Application\Models\Authorisation 
     */
    public function getAuthorisation()
    {
        return $this->authorisation;
    }

    /**
     * Set role
     *
     * @param \Application\Models\Role $role
     * @return RoleAuthorisation
     */
    public function setRole(\Application\Models\Role $role = null)
    {
        $this->role = $role;
    
        return $this;
    }

    /**
     * Get role
     *
     * @return \Application\Models\Role 
     */
    public function getRole()
    {
        return $this->role;
    }
}