<?php
include APPLICATION_PATH . '/DAO/UtilisateurDAO.php';
include APPLICATION_PATH . '/DAO/AuthorisationDAO.php';
include APPLICATION_PATH . '/DAO/RoleDAO.php';
include APPLICATION_PATH . '/DAO/RoleAuthorisationDAO.php';
include APPLICATION_PATH . '/DAO/LogDAO.php';
include PUBLIC_PATH.'/Fonctions/Fonction.php';
#include PUBLIC_PATH . '/files_to_include/Constantes.php';

class ModuleUser
{
    protected $user;
     
    public function connect(){
        
         $login = isset($_POST["login"])?  $_POST["login"] : null;
       $password = isset($_POST['password'])? sha1(md5($_POST["password"])) : null;
       $userDao = new UtilisateurDAO();
       $roleAuthDao = new RoleAuthorisationDAO();
       $user =  $userDao->getUtilisateurLoginPassword($login, $password);
       if ( is_object($user)){
           session_cache_limiter('private_no_expire');
           session_cache_expire(60);
           session_start();
           $_SESSION["codeUser"] = $user->getCode();
           $_SESSION["nameUser"] = $user->getName();
            //Module d'enregistrement des logs 
            try {
                $f = new Fonction();
               
                $descr = "Connexion de l'utilisateur " . $user->getName() . ", dont le login est " . $user->getLogin() . "";
                
                $f->EnregistrerLog($descr, $user);
                
            } catch (Exception $exc) {
                  $response = array('type' => "error", 'msg' => $exc->getMessage(),"result"=>array());
                 echo json_encode($response);
                 exit();
            }
            $authDao = new AuthorisationDAO();
            $listeParent = $authDao->listAuthParent();
            $list=$roleAuthDao->listRoleAuthorisationByRole($user->getRole());
            
            $result = [];
            
          foreach($listeParent as $parent){
             if($roleAuthDao->roleAuth($user->getRole(),$parent)){
                  $result[$parent->getCode()][] = array("code"=>$parent->getCode(),"label"=>$parent->getLabel(),"action"=>$parent->getAction(),"parent"=>NULL,"icon"=>$parent->getIcon());
                foreach($list as $elem){
                    if ($parent == $elem->getAuthorisation()->getParent()){
                          $result[$parent->getCode()][] = array("code"=>$elem->getAuthorisation()->getCode(),"label"=>$elem->getAuthorisation()->getLabel(),"action"=>$elem->getAuthorisation()->getAction(),"parent"=>$parent->getCode(),"icon"=>$elem->getAuthorisation()->getIcon(),"controler"=>$elem->getAuthorisation()->getControleur());
                     }
                  }
             }
           
                
          }
            
           echo json_encode(array("type" => "success",'msg' => "Connexion reussie","result"=>$result));
            exit();
       }else{
           
           echo json_encode(array("type" => "error","result"=>array()));
       }
       exit();
    }
   
    public function adduserAction()
    {
       
        // action body
        if (!empty($_POST)) {
            $error = 0;
            $data = $_POST['data'];
            $data = json_decode($data);
            $name = trim($data->name);
            $sexe = trim($data->sexe);
            $login = trim($data->login);
            $role = $data->role;
            $password = sha1(md5($data->password));
            $cni = trim($data->cni);
            $birthday = new \DateTime($data->date);
            $phone = trim($data->phone);

            try {
                
                $userDAO = new UtilisateurDAO();
                $userExistant = $userDAO->getUtilisateurByLogin($login);
                
                if(!is_null($userExistant))
                    {

                        $response = array('type' => "error", 'msg' => "Ce login est déjà attribué. Veuillez en choisir un autre.");
                        echo json_encode($rep);
                        exit();
                    }
                    
                    $roleDao = new RoleDAO();
                    $role = $roleDao->getRoleByCode($role);
               if(is_object($role)){
                    $userDao->_em->beginTransaction();
                    $user = new \Application\Models\Utilisateur();
                    $user->setBirthday($birthday);
                    $user->setCni($cni);
                    $user->setName($name);
                    $user->setPassword($password);
                    $user->setPhone($phone);
                    $user->setLogin($login);
                    $user->setState(1);
                    $user->setDatecreation(new \DateTime());
                    $user->setCode(str_replace(' ', '', microtime()));
                    $userDAO->save($user);
                    
                    $roleUserDao = new RoleUtilisateurDAO();
                    $roleUser = new \Application\Models\RoleUtilisateur();
                    $roleUser->setCode(str_replace(' ', '', microtime()));
                    $roleUser->setDateattribution(new \DateTime());
                    $roleUser->setUtilisateur($user);
                    $roleUser->setRole($role);
                    $roleUser->setState(1);
                    
                    
                    $roleUserDao->save($roleUser);
                    
                
                }
               
                $f = new Fonction();
               
                $descr = "Enregistrement de l'utilisateur " . $name . ", dont le login est " . $login . "";
                
                $user = $this->user;
                $f->EnregistrerLog($descr, $user);
                
                $userDAO->_em->commit();
               $response = array('type' => "success", 'msg' => "Enregistrement de l'utilisateur effectué avec succes");
                 echo json_encode($response);
                 exit();
                 
            } catch (Exception $exc) {
               $userDAO-> _em->rollBack();
                $response = array('type' => "error", 'msg' => "Echec d'enregistrement de l'utilisateur");
                 echo json_encode($response);
                 exit();
            }
           
        } 
    }
    public function sayHello(){
        echo json_encode("Bonjour");
        exit();
    }
    public function authUser(){
        $codeUser = trim($_POST["codeUser"]);

        $authDao = new AuthorisationDAO();
        $roleAuthDao=new RoleAuthorisationDAO();
         
        $userDao = new UtilisateurDAO(); 
        $user=$userDao->getUtilisateurByCode($codeUser);
       
        
        
            $result = [];
           $list=$roleAuthDao->listRoleAuthorisationByRole($user->getRole());
            $result = [];
            foreach($list as $elem){
                $auth = $elem->getAuthorisation();
                if(is_object($auth->getParent())){
                    $result[] = array("code"=>$auth->getCode(),"label"=>$auth->getLabel(),"action"=>$auth->getAction(),"parent"=>$auth->getParent()->getLabel());
                }else{
                    $result[] = array("code"=>$auth->getCode(),"label"=>$auth->getLabel(),"action"=>$auth->getAction());
                }
                
            }
         
        echo json_encode(array("type" => "success",'msg' => "Connexion reussie","result"=>$result));
        exit;
    }

    public function editerAction()
    {
        
        $utilisateurDao = new UtilisateurDAO();
        $profilDao = new ProfilDAO();

        if (!empty($_POST["data"])) {

             $error = 0;
            $data = $_POST['data'];
             $data = json_decode($data);
            $nom = trim($data->nom);
            $nomJeune = trim($data->nomJeune);
            $prenom = trim($data->prenom);
            $sexe = trim($data->sexe);
            $login = trim($data->login);
            $profils = $data->profil;
            $password = sha1(md5($data->password));
            $carte = trim($data->cni);
            $date = new \DateTime($data->date);
            $telephone = trim($data->telephone);
            $nationalite = trim($data->nationalite);
            $lieu = trim($data->lieu);
            $DateLivCni = new \DateTime($data->delivrerCni);
            $lieuLivCni = trim($data->delivrerLieu);
            $idUser = (int)$data->user;
            

            try {
                $utilisateurDao->_em->beginTransaction();
                    $utilisateur = $utilisateurDao->getUtilisateurById($idUser);
                    if(is_object($utilisateur)){
                          $profilDao = new ProfilDAO();
                          $profil = $profilDao->getProfil((int)$profils);
                       if(is_object($profil)){
                            if($nom!=null && $nom!=""){
                                    $utilisateur->getIdpersonne()->setNom($nom);
                                  }
                                   if($nomJeune!=null && $nomJeune!=""){
                                    $utilisateur->getIdpersonne()->setNomJeunefille($nomJeune);
                                  }
                                if($prenom!=null && $prenom!=""){
                                    $utilisateur->getIdpersonne()->setPrenom($prenom);
                                }
                                if($sexe!=null && $sexe!=""){
                                    $utilisateur->getIdpersonne()->setSexe($sexe);
                                }
                                if($carte!=null && $carte!=""){
                                    $utilisateur->getIdpersonne()->setNumcarte($carte);
                                }
                                if($telephone!=null && $telephone!=""){
                                    $utilisateur->getIdpersonne()->setTelephone($telephone);
                                }
                                if($nationalite!=null && $nationalite!=""){
                                    $utilisateur->getIdpersonne()->setNationalite($nationalite);
                                }
                                if($lieu!=null && $lieu!=""){
                                    $utilisateur->getIdpersonne()->setLieunaissance($lieu);
                                }
                                 if($lieuLivCni!=null && $lieuLivCni!=""){
                                    $utilisateur->getIdpersonne()->setLieudelivrancecni($lieuLivCni);
                                }
                                 if($DateLivCni!=null && $DateLivCni!=""){
                                    $utilisateur->getIdpersonne()->setDatedelivrancecni($DateLivCni);
                                }
                                if($nationalite!=null && $nationalite!=""){
                                    $utilisateur->getIdpersonne()->setNationalite($nationalite);
                                }
                                if(is_object($date)){
                                    $utilisateur->getIdpersonne()->setDatenaissance($date);
                                }
                                if($login!=null && $login!=""){
                                    $utilisateur->setLogin($login);
                                }
//                                if($password!=null && $password!=""){
//                                    $utilisateur->setPassword($password);
//                                }
                                $utilisateur->setIdprofil($profil);
                               
                       }
                                
                       
                       $personneDao = new PersonneDAO();
                                $personneDao->modifier($utilisateur->getIdpersonne());
                                $utilisateurDao->modifier($utilisateur);
                                 $utilisateurDao->_em->commit();
                                $rep = array('msg' => 1,'msg1'=>"Modification effectuer avec success");
                    }else{
                        $utilisateurDao-> _em->rollBack();
                        $error = 1;
                    //$this->view->errormsg=$e->getMessage();
                    $errormsg = "Utilisateur incorrect"; //"Echec d'enregistrement";
                    $rep = array('msg' => $error, 'msg1' => $errormsg);
                    echo json_encode($rep);
                    exit();
                    }
                    
                    
                 
            }catch (Exception $exc) {
               $utilisateurDao->_em->rollBack();
                $error = 1;
                $errormsg = $exc->getMessage() ; //"Echec d'enregistrement";
               
            }
            if ($error == 1) {
                $rep = array('msg' => $error, 'msg1' => $errormsg);
            } else {
                
                try {
                $f = new Fonction();
               
                $descr = "Enregistrement de l'utilisateur " . $nom . ", dont le login est " . $login . "";
                
                $user = $this->user;
                $f->EnregistrerLog($descr, $user);
                
            } catch (Exception $exc) {

            }
                $rep = array('msg' => $error, 'msg1' => "enregistrement effectué avec succes");
                
            }
            echo json_encode($rep);
            exit();
        }else{
            $id = $this->getRequest()->getParam('id');
        $objuti = new UtilisateurDAO();
        $utilisateur = $objuti->getUtilisateurById($id);
        $profilDAO = new ProfilDAO();
        $profils = $profilDAO->lister();
        $this->view->profils = $profils;
        $this->view->utilisateur = $utilisateur;
            
        }
        
        
    }
     public function datatableAction()
    {
       $table = 'utilisateurs';

        $primaryKey = 'idutilisateur';
        $columns = array(
            array('db' => 'nom', 'dt' => 0),
            array('db' => 'prenom', 'dt' => 1),
            array('db' => 'idutilisateur' , 'dt' => 2),
            array('db' => 'sexe' , 'dt' => 3),
            array('db' => 'cni' , 'dt' => 4),
            array('db' => 'nomprofil' , 'dt' => 5)
        );

        $sql_details = array(
            'user' => DB_USER,
            'pass' => DB_PASSWORD,
            'db' => DB_NAME,
            'host' => HOSTNAME
        );

         
        require(PUBLIC_PATH . '/files_to_include/ssp.class.php');

        $resultatDataTable = SSP::simple($_POST, $sql_details, $table, $primaryKey, $columns);
        $finalResult = array();
        $finalResult["draw"] = $resultatDataTable["draw"];
        $finalResult["recordsTotal"] = $resultatDataTable["recordsTotal"];
        $finalResult["recordsFiltered"] = $resultatDataTable["recordsFiltered"];
        $finalResult["data"] = array();
       foreach ($resultatDataTable["data"] as $ligneTableau) {
           $id = (int)$ligneTableau[2];
           $newLigne = array( $ligneTableau[0] , $ligneTableau[1],$ligneTableau[3],$ligneTableau[4],$ligneTableau[5]);
//            $host = $this->getRequest()->getServer('HTTP_HOST');
            $urlEditer = $this->_helper->url->url(array('controller' => 'Utilisateur', 'action' => 'editer', 'id' => $id));
            $urlConsulter = $this->_helper->url->url(array('controller' => 'Utilisateur', 'action' => 'consulter', 'id' => $id));
            $chaine = "<a href='"  .$urlEditer .  "'><i title='editer l utilisateur ' class='fa  fa-edit '></i></a>";
             $chaine .= "<a href='"  .$urlConsulter .  "'><i title='editer l utilisateur ' class='fa  fa-eye '></i></a>";
             //$chaine .= "<a href='#' class='consultePurpose' idUtilisateur='" . $id . "'><i class='fa fa-eye' title='consulter l utilisateur '></i></a>";
            $chaine .= "<a href='#' class='deletePurpose' idUtilisateur='" . $id . "'><i class='fa fa-trash' title='supprimer l utilisateur '></i></a>";
            
            $newLigne[] = utf8_encode($chaine);
            $finalResult["data"][] = $newLigne;
        }
        
        echo json_encode($finalResult);
        exit();
    }
    public function consulterAction()
    {
        $id = $this->getRequest()->getParam('id');
        $objuti = new UtilisateurDAO();
        $utilisateur = $objuti->getUtilisateurById($id);
        $profilDAO = new ProfilDAO();
        $profils = $profilDAO->lister();
        $this->view->profils = $profils;

        $this->view->utilisateur = $utilisateur;
         
    }

    public function supprimerAction()
    {
        if (!is_null($this->getRequest()->getParam('idUser'))) {

            $id = $this->getRequest()->getParam('idUser');
            
            try {
                $user = new UtilisateurDAO();
                $utilisateur = $user->getUtilisateurById($id);
                if (empty($utilisateur)) {
                    $rep = array('msg' => "Impossible de trouver l'utilisateur");
                } else {
                    try {
                        $utilisateur->setStatut(0);
                        $user->modifier($utilisateur);
                        $rep = array("type"=>"success",'msg1' => "Suppression effectue avec success");
                        try {
                            $f = new Fonction();

                            $descr = "Suppression de l'utilisateur " . $utilisateur->getIdpersonne()->getNom() . ", dont le login est " . $utilisateur->getLogin() . "";
                            
                            //$user = $this->user;
                            $f->EnregistrerLog($descr, $utilisateur);

                        } catch (Exception $exc) {

                        }
                        
                    } catch (Exception $ex) {
                        $rep = array("type"=>"echec",'msg1' => "Echec de suppression");
                        echo $ex->getMessage();
                    }
                }
            } catch (Exception $ex) {
                $rep = array("type"=>"echec",'msg1' => "Echec de suppression");
                echo $ex->getMessage();
            }
        } else {
            $rep = array("type"=>"echec",'msg1' => "Aucun élément à supprimer");
        }
        echo json_encode($rep);
        exit();
    }

    public function checkvalidationAction()
    {
        $utilisateurDao = new UtilisateurDAO();
        //$crypt = new Fonction();
        
        if ( !empty($_POST)){
            $password = $_POST["password"];
            $login = $_POST["login"];
            
            $pwdCrypte = sha1(md5($password));
            
            
                $user = $utilisateurDao->obtenirUserPwdValidation($login, $pwdCrypte);
                if ( !empty($user)){
                    echo json_encode(array("type" => "success"));
                }else{
                    echo json_encode(array("type" => "error"));
                }
            
            exit();
        }
        exit();
    }

    public function motdepasseAction()
    {
        if ( !empty($_POST)){
            if ( empty($_POST["ancien"]) || empty($_POST["nouveau"])){
                echo json_encode(array("type" => "error" , "message" => "Paramètres manquants"));
                exit();
            }
            $idUtilisateur = (int)$_SESSION["idUtilisateur"];
            $utilisateurDao = new UtilisateurDAO();
            $utilisateur = $utilisateurDao->getUtilisateurById($idUtilisateur);
            $ancienMotDePasse = sha1(md5($_POST["ancien"]));
            $nouveauMotDePasse = sha1(md5($_POST["nouveau"]));
            if ( $utilisateur->getPassword() != $ancienMotDePasse ){
                echo json_encode(array("type" => "error" , "message" => " Veuillez renseigner votre mot de passe courant" ));
                exit();
            }
            $utilisateur->setPassword($nouveauMotDePasse);
            $utilisateurDao->modifier($utilisateur);
            echo json_encode(array("statut"=>1,"type" => "success"));
            exit();
        }
    }
     public function findAction()
    {
         
        try{
           $nom = trim($_POST["nom"]) ;
          $personneDao = new PersonneDAO();
           $liste= $personneDao->chercherClient($nom);
           $resultat = array();
           foreach ( $liste as $personne ){
               $resultat[]=["id"=>$personne->getIdpersonne(),"value"=>$personne->getNom()." ".$personne->getPrenom()];
              
           }
           echo json_encode(array('data'=>$resultat,'nb'=>count($resultat)));
        } catch (Exception $ex) {
           echo json_encode(array("type" => "error"));
        }
        
        exit();
        
        
    }

}



