<?php

include APPLICATION_PATH . '/api/LaboApi.php';

class LaboController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        session_start();
        if ( isset($_SESSION["codeUser"])){
             $_SESSION["derniereAction"] = new \DateTime();
             $utilisateurDao = new UtilisateurDAO();
             $roleAuthDao = new RoleAuthorisationDAO();
            $user = $utilisateurDao->getUtilisateurByCode($_SESSION["codeUser"]);
            if(is_object($user)){
                if(!$roleAuthDao->existController($user->getRole(), "Role")){
                    $this->_helper->redirector('index' , 'Index');
                }
            }else{
                $this->_helper->redirector('index' , 'Index');
            }
        }else{
            $this->_helper->redirector('index' , 'Index');
        }
    }

    public function indexAction()
    {
         $userDao = new UtilisateurDAO();
        $connexion = $userDao->_em->getConnection();
        $sql = "drop table if exists labos; CREATE  TABLE IF NOT EXISTS labos(PRIMARY KEY (code)) SELECT l.code,p.nom as parent,l.nom,l.description,l.phone,l.email  FROM laboratoire l left join laboratoire p on l.parent=p.code WHERE l.state= 1 ";
        $requete = $connexion->prepare($sql);
        $requete->execute();
    }
     public function datatableAction()
    {
       $moduleLabo = new ModuleLabo();
       $moduleLabo->listLabo();
    }

    public function enregistrerAction()
    {
       
        if (!empty($_POST)) {
           $moduleLabo = new ModuleLabo();
           $moduleLabo->addLabo();
        } else {
            $authDao = new AuthorisationDAO();
            $this->view->auths = $authDao->listAuthParent();
        }

    }
    public function editerAction()
    {
       $authDao = new AuthorisationDAO();
        $roleAuthDao = new RoleAuthorisationDAO();
        $roleDao = new RoleDAO();
        $laboDao = new LaboDAO();
        
        if ($this->getRequest()->getMethod() == 'POST' && !empty($_POST)) {
             $moduleLabo = new ModuleLabo();
             $moduleLabo->editLabo();
            
        }else{
            $code = $this->getRequest()->getParam('code');
            $this->view->labo = $laboDao->getLaboByCode($code);
           
        }
        
        
    }
    
    public function deleteAction()
    {
        if (!empty($_POST)) {

            $moduleRole = new ModuleRole();
             $moduleRole->deleteRole();
        }else{
                    $rep = array('type' => "error", 'msg' => "Requete mal formée");
                          echo json_encode($rep);
                         exit();
        }
    }
       public function findAction()
    {
         $moduleLabo = new ModuleLabo();
       $moduleLabo->findLabo();
    }

}

