/*
 * Code destiné à la gestion des notifications sur l'interface d'administration lors
 * de la création de tickets
 * L'idée est de demander à chaque fois les tickets récents par rapport à une certaine
 * date , naturellement lors du premier appel , ladite date correspondra à la date courante 
 * mais tous les appels suivants cette date sera la date de fin du précent appel
 */

// Date du précédent appel
var ticket_date_appel = undefined;

/* Condition d'application de la notification : Il faut être un admin_primo
 * Il est important de noter que dans les fichiers de menus inclus , la balise
 * mère a pour id aside-menu et un attribut target-user qui prend valeur dans 
 * le tableau ['admin_boutique' , 'admin_primo' , 'admin_saisie']
 */
var ticket_type_admin = $("#aside-menu").attr("target-user");

function notifyticket(urlServeur){
    if( ticket_type_admin === "admin_primo" ){
        var params = {type : "POST"};
        if ( ticket_date_appel !== undefined ){
            params.date = ticket_date_appel;
        }
        
        $.ajax({
            url : urlServeur,
            data : params,
            dataType : "json",
            beforeSend : function(){
                
            },
            error : function(){
                $.toast({
                   heading :  " Serveur inactif ",
                   text : " Les notifications ne seront malheureusement pas fonctionnelles",
                   hideAfter : false,
                   icon : "error",
                   type : "POST",
                   stack : false,
                   position : "top-left"
                });
            },
            success : function(data){
                if ( data.type === "success" ){
                    ticket_date_appel = data.date;
                    if ( date.nombre > 0 ){
                        $.toast({
                            heading : "Tickets",
                            text : " " + nombre + " ticket(s) nouvellement créé(s) ",
                            icon : "info",
                            hideAfter : false,
                            stack : false,
                            position : "top-left"
                        });
                    }
                }else{
                    $.toast({
                       heading : "erreur serveur",
                       text : " Problème rencontré de la notification de ticket",
                       icon : "error",
                       hideAfter : false,
                       stack : false,
                       position : "top-left"
                    });
                }
            },
            complete : function(){
                setTimeout(notifyticket(urlServeur) , 6000);
            }
        });
    }
}
