<?php

/*
 * Model's function for Personne Entity
 */

/**
 * @author Landry Messanga <messangalandry@gmail.com>
 */

include  APPLICATION_PATH. '/Models/Personne.php';

class PersonneDAO {
    //put your code here
    public  $formule;
    public $_em;
    
    function PersonneDAO(){
        $this->formule =new \Application\Models\Personne();
        $registry = Zend_Registry::getInstance();
        $this->_em = $registry->entitymanager;
    }
    
    /**
     * 
     * @param Application\Models\Personne $personne
     */
    public function enregistrer($personne){
        
        $this->_em->persist($personne);
        $this->_em->flush();
    }
    
    /**
     * 
     * @param Application\Models\Personne $personne
     */
    public function modifier($personne){
        
        $this->_em->merge($personne);
        $this->_em->flush();
    }
    
    /**
     * 
     * @param Application\Models\Personne $personne
     */
    public function supprimer($personne){
        
        $this->_em->merge($personne);
        $this->_em->flush();
    }
    
    /**
     * 
     * @param integer $id
     * @return Application\Models\Personne
     */
    public function getPersonne($id){
       
        $personne = $this->_em->getRepository('\Application\Models\Personne')->findOneBy(array('idpersonne'=>(int)$id));
        
        return $personne;
    }
    
    /**
     * 
     * @param 
     * @return Application\Models\Personne
     */
    public function listerClients(){
        $liste = $this->_em->getRepository('\Application\Models\Personne')
                ->findBy(array('statut'=> 1, 'type'=> TYPE_PERSONNE_CLIENT), array('idPersonne'=> 'DESC'));
           return $liste;
    }
    
    /**
     * 
     * @param string $numTel
     * @return Application\Models\Personne
     */
    public function ObtenirClientParNumtel($numTel){
        $personne = $this->_em->getRepository('\Application\Models\Personne')->findBy(array("type" => TYPE_PERSONNE_CLIENT , "telephone" => $numTel, "statut" => 1));
        return $personne;
    }
    
    /**
     * 
     * @param string $nom
     * @return \Application\Models\CLient
     */
    public function chercherClient($nom){
        
        try {
            $resultat = $this->_em->getRepository("\Application\Models\Personne")->createQueryBuilder("p")
                    ->Where("p.statut=1")
                    ->andWhere("p.nom LIKE :nom")
                    ->setParameter("nom",  "%".$nom . "%")
                    ->getQuery()
                    ->getResult();
            return $resultat;
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }

    }
    
    
    
   
    
	
}

