<?php

/*
 * Model's functions of Profil Entity
 */

/**
 * @author Messanga Landry <messangalandry@gmail.com>
 */

include APPLICATION_PATH . '/Models/Profil.php';

class ProfilDAO {
     public $_em;
    
    function ProfilDAO(){
        $registry = Zend_Registry::getInstance();
        $this->_em = $registry->entitymanager;
    }
    
    /**
     * 
     * @param Application\Models\Profil $profil
     */
    public function enregistrer($profil){
        
        $this->_em->persist($profil);
        $this->_em->flush();
    }
     
    
    /**
     * 
     * @param Application\Models\Profil $profil
     */
    public function editer($profil){
        $this->_em->merge($profil);
        $this->_em->flush();
    }
    
    /**
     * 
     * @param integer $id
     * @return Application\Models\Profil
     */
    public function getProfil($id){
        $profil = $this->_em->getRepository('\Application\Models\Profil') ->find((int)$id);
        return $profil;
    }
    
    /**
     * 
     * @param 
     * @return Application\Models\Profil
     */
     public function lister(){
        $liste = $this->_em->getRepository('\Application\Models\Profil')->findBy(array("statut"=>1));
           return $liste;
    }
    
    
  
    /**
     * 
     * @param string $name
     * @return Application\Models\Profil
     */
    public function existProfilName($name){
         $profil = $this->_em->createQueryBuilder()
                ->select('p.nom')
                ->from('\Application\Models\Profil', 'p')
                ->where('p.nom like :nom')
                ->andWhere('p.statut = :statut')
                ->setParameter('nom', $name)
                ->setParameter('statut', 1)
                ->getQuery();
        
        if(!empty($profil) && is_array($profil)) return true;
        else return false;
    }
    /**
     * 
     * @param string $nom
     * @return \Application\Models\Profil
     */
    public function chercherProfilParNom( $nom ){
        try{
            $liste = $this->_em->getRepository("\Application\Models\Profil")->createQueryBuilder("a")
                             ->where("a.statut = 1")
                             ->andWhere("UPPER(a.nom) LIKE :nom")
                             ->setParameter("nom" , '%'.strtoupper($nom) . '%')
                             ->getQuery()
                             ->getResult();
            return $liste;
        } catch (Exception $ex) {
            return array();
        }
        
    }
    
}
