<?php

/*
 * Model's function for Personne Entity
 */

/**
 * @author Messanga Landry <messangalandry@gmail.com>
 */

include  APPLICATION_PATH. '/Models/Utilisateur.php';

class UtilisateurDAO {
    //put your code here
    public  $formule;
    public $_em;
    
    function UtilisateurDAO(){
        $this->formule =new \Application\Models\Utilisateur();
        $registry = Zend_Registry::getInstance();
        $this->_em = $registry->entitymanager;
    }
    
    /**
     * 
     * @param Application\Models\Utilisateur $utilisateur
     */
    public function enregistrer($utilisateur){
        
        $this->_em->persist($utilisateur);
        $this->_em->flush();
    }
    
    /**
     * 
     * @param Application\Models\Utilisateur $utilisateur
     */
    public function modifier($utilisateur){
        
        $this->_em->merge($utilisateur);
        $this->_em->flush();
    }
    
    /**
     * 
     * @param Application\Models\Utilisateur $utilisateur
     */
    public function supprimer($utilisateur){
        
        $this->_em->merge($utilisateur);
        $this->_em->flush();
    }
    
    /**
     * 
     * @param integer $id
     * @return Application\Models\Utilisateur
     */
    public function getUtilisateurById($id){
        $user = $this->_em->getRepository('\Application\Models\Utilisateur')->find((int)$id);
        return $user;
    }
     /**
     * 
     * @param String $login
     * @return Application\Models\Utilisateur
     */
    public function obtenirUtilisateurLogin($login){
        $listObj = $this->_em->getRepository('\Application\Models\Utilisateur')->findBy(array("login" => $login , "statut" => 1));
        if (count($listObj)>0)
            return $listObj[0];
        return null;
    }
     /**
     * 
     * @param Application\Models\Personne
     * @return Application\Models\Utilisateur
     */
    public function getUserByPersonne($personne){
        $user = $this->_em->getRepository('\Application\Models\Utilisateur')->findOneBy(array("idpersonne" => $personne , "statut" => 1));
        
        return $user;
    }
  /**
     * 
     * @param String $login
     * @param String $password
     * @return Application\Models\Utilisateur
     */
    public function getUtilisateurLoginPassword($login , $password){
           $user =  $this->_em->getRepository("\Application\Models\Utilisateur")->findOneBy(array('login' => $login , 'password' => $password, "statut" => 1));
          
           if ( $user ){
               return $user;
           }else{
               return null;
           }
    }
    
     /**
    
     * @return Application\Models\Utilisateur
     */
    public function lister(){
           $liste =  $this->_em->getRepository("\Application\Models\Utilisateur")->findBy(array("statut" => 1));
          
           return $liste;
    }
    
     /**
    
     * @return Application\Models\Utilisateur
     */
    public function listerClient(){
        $null = NULL;
          $liste = $this->_em->createQueryBuilder() 
                      ->select("u")
                      ->from('\Application\Models\Utilisateur','u') 
                      ->where("u.statut = 1")
                      ->andWhere("u.idprofil is NULL ")
                      ->andWhere("u.idprofil is NULL")
                        ->andWhere("u.login  is NULL")
                        ->andWhere("u.password  is NULL ")
                      ->getQuery()
                      ->getResult();
        
        return $liste;
    }
    
    
   
    
	
}

