<?php

namespace Application\Models;

use Doctrine\ORM\Mapping as ORM;

/**
 * Covid
 *
 * @ORM\Table(name="covid")
 * @ORM\Entity
 */
class Covid
{
    /**
     * @var string
     *
     * @ORM\Column(name="grippe_num_inclusion", type="string", length=20, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $grippeNumInclusion;

    /**
     * @var string
     *
     * @ORM\Column(name="covid_pays_provenance", type="string", length=256, nullable=true)
     */
    private $covidPaysProvenance;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateSaisie", type="date", nullable=true)
     */
    private $datesaisie;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_antibiotique", type="boolean", nullable=true)
     */
    private $grippeAntibiotique;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_antipaludique", type="boolean", nullable=true)
     */
    private $grippeAntipaludique;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_antipyretique", type="boolean", nullable=true)
     */
    private $grippeAntipyretique;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_antiviral", type="boolean", nullable=true)
     */
    private $grippeAntiviral;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_arthralgies", type="string", length=10, nullable=true)
     */
    private $grippeArthralgies;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_asthenie", type="boolean", nullable=true)
     */
    private $grippeAsthenie;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_asthme", type="string", length=10, nullable=true)
     */
    private $grippeAsthme;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_autre_co_morbidi", type="string", length=60, nullable=true)
     */
    private $grippeAutreCoMorbidi;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_autre_exposion", type="string", length=60, nullable=true)
     */
    private $grippeAutreExposion;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_cas_semblable", type="string", length=10, nullable=true)
     */
    private $grippeCasSemblable;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_cephalee", type="string", length=10, nullable=true)
     */
    private $grippeCephalee;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_classification", type="string", length=30, nullable=true)
     */
    private $grippeClassification;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_co_mord_cardio", type="string", length=10, nullable=true)
     */
    private $grippeCoMordCardio;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_co_mord_renal", type="string", length=10, nullable=true)
     */
    private $grippeCoMordRenal;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_conjonctivite", type="boolean", nullable=true)
     */
    private $grippeConjonctivite;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_contact_covid_conf_labo", type="string", length=10, nullable=true)
     */
    private $grippeContactCovidConfLabo;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_convulsion", type="boolean", nullable=true)
     */
    private $grippeConvulsion;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="grippe_date_deces", type="date", nullable=true)
     */
    private $grippeDateDeces;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="grippe_date_entree_cmr", type="date", nullable=true)
     */
    private $grippeDateEntreeCmr;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="grippe_date_examen", type="date", nullable=true)
     */
    private $grippeDateExamen;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="grippe_date_hospitalisation", type="date", nullable=true)
     */
    private $grippeDateHospitalisation;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="grippe_date_naissance", type="date", nullable=true)
     */
    private $grippeDateNaissance;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="grippe_date_prelev", type="date", nullable=true)
     */
    private $grippeDatePrelev;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="grippe_date_prelev_c1", type="date", nullable=true)
     */
    private $grippeDatePrelevC1;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="grippe_date_prem_symptome", type="date", nullable=true)
     */
    private $grippeDatePremSymptome;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="grippe_date_recept_echant", type="date", nullable=true)
     */
    private $grippeDateReceptEchant;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_decede", type="boolean", nullable=true)
     */
    private $grippeDecede;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_diabete", type="string", length=10, nullable=true)
     */
    private $grippeDiabete;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_diagnost_clinique", type="string", length=100, nullable=true)
     */
    private $grippeDiagnostClinique;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_diarrhee", type="boolean", nullable=true)
     */
    private $grippeDiarrhee;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_doul_oreille", type="string", length=10, nullable=true)
     */
    private $grippeDoulOreille;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_echant_apres_deces", type="boolean", nullable=true)
     */
    private $grippeEchantApresDeces;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_ecouv_gorge", type="boolean", nullable=true)
     */
    private $grippeEcouvGorge;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_ecouv_nasopharynge", type="boolean", nullable=true)
     */
    private $grippeEcouvNasopharynge;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_enfant", type="string", length=20, nullable=true)
     */
    private $grippeEnfant;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_eruption_cutanee", type="boolean", nullable=true)
     */
    private $grippeEruptionCutanee;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_essouflement", type="boolean", nullable=true)
     */
    private $grippeEssouflement;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_form_sanitaire", type="string", length=60, nullable=true)
     */
    private $grippeFormSanitaire;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_freq_cardiaque", type="string", length=20, nullable=true)
     */
    private $grippeFreqCardiaque;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_freq_respi", type="string", length=10, nullable=true)
     */
    private $grippeFreqRespi;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_gueri", type="boolean", nullable=true)
     */
    private $grippeGueri;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="grippe_heure_prelev", type="time", nullable=true)
     */
    private $grippeHeurePrelev;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="grippe_heure_recept_echant", type="time", nullable=true)
     */
    private $grippeHeureReceptEchant;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_immuno_depression", type="string", length=10, nullable=true)
     */
    private $grippeImmunoDepression;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_incapacite_boire", type="boolean", nullable=true)
     */
    private $grippeIncapaciteBoire;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_lethargie_incons", type="boolean", nullable=true)
     */
    private $grippeLethargieIncons;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_mal_gorge", type="string", length=10, nullable=true)
     */
    private $grippeMalGorge;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_malade", type="boolean", nullable=true)
     */
    private $grippeMalade;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_myalgies", type="string", length=10, nullable=true)
     */
    private $grippeMyalgies;

    /**
     * @var integer
     *
     * @ORM\Column(name="grippe_nbre_jr_hospitalisation", type="bigint", nullable=true)
     */
    private $grippeNbreJrHospitalisation;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_negatif_fievre", type="string", length=11, nullable=true)
     */
    private $grippeNegatifFievre;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_nom_prenom", type="string", length=70, nullable=true)
     */
    private $grippeNomPrenom;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_num_inclusion_c1", type="string", length=20, nullable=true)
     */
    private $grippeNumInclusionC1;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_parent", type="string", length=20, nullable=true)
     */
    private $grippeParent;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_pays_covid", type="boolean", nullable=true)
     */
    private $grippePaysCovid;

    /**
     * @var integer
     *
     * @ORM\Column(name="grippe_poids", type="integer", nullable=true)
     */
    private $grippePoids;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_positif_fievre", type="string", length=11, nullable=true)
     */
    private $grippePositifFievre;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_preciser", type="string", length=60, nullable=true)
     */
    private $grippePreciser;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_preciser_autre_expo", type="string", length=100, nullable=true)
     */
    private $grippePreciserAutreExpo;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_prenom", type="string", length=60, nullable=true)
     */
    private $grippePrenom;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_region_cmr", type="string", length=20, nullable=true)
     */
    private $grippeRegionCmr;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_resp_siflante", type="boolean", nullable=true)
     */
    private $grippeRespSiflante;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_result_genotypage", type="string", length=11, nullable=true)
     */
    private $grippeResultGenotypage;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_result_pcr", type="string", length=20, nullable=true)
     */
    private $grippeResultPcr;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_result_pcr_c1", type="string", length=20, nullable=true)
     */
    private $grippeResultPcrC1;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_rhinorrhee", type="boolean", nullable=true)
     */
    private $grippeRhinorrhee;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_sign_autre", type="boolean", nullable=true)
     */
    private $grippeSignAutre;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_so2", type="string", length=10, nullable=true)
     */
    private $grippeSo2;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_sous_antipyretique", type="boolean", nullable=true)
     */
    private $grippeSousAntipyretique;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_sous_type_fievre", type="string", length=15, nullable=true)
     */
    private $grippeSousTypeFievre;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_statut_cas", type="string", length=20, nullable=true)
     */
    private $grippeStatutCas;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_tel_patient", type="string", length=60, nullable=true)
     */
    private $grippeTelPatient;

    /**
     * @var float
     *
     * @ORM\Column(name="grippe_temperature", type="decimal", nullable=true)
     */
    private $grippeTemperature;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_tirage_sous_costal", type="boolean", nullable=true)
     */
    private $grippeTirageSousCostal;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_toux", type="boolean", nullable=true)
     */
    private $grippeToux;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_type_cas", type="string", length=30, nullable=true)
     */
    private $grippeTypeCas;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_type_prelevement", type="string", length=20, nullable=true)
     */
    private $grippeTypePrelevement;

    /**
     * @var string
     *
     * @ORM\Column(name="grippe_ville", type="string", length=30, nullable=true)
     */
    private $grippeVille;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_vomiss_incoherci", type="boolean", nullable=true)
     */
    private $grippeVomissIncoherci;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_vomissement", type="boolean", nullable=true)
     */
    private $grippeVomissement;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_yeux_rouges", type="boolean", nullable=true)
     */
    private $grippeYeuxRouges;

    /**
     * @var string
     *
     * @ORM\Column(name="orgUnit", type="string", length=40, nullable=true)
     */
    private $orgunit;

    /**
     * @var string
     *
     * @ORM\Column(name="sexe", type="string", length=15, nullable=true)
     */
    private $sexe;

    /**
     * @var boolean
     *
     * @ORM\Column(name="vaccination_grippe_fievre", type="boolean", nullable=true)
     */
    private $vaccinationGrippeFievre;

    /**
     * @var integer
     *
     * @ORM\Column(name="sms", type="smallint", nullable=true)
     */
    private $sms;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_stridor", type="boolean", nullable=true)
     */
    private $grippeStridor;

    /**
     * @var boolean
     *
     * @ORM\Column(name="grippe_test_controle", type="boolean", nullable=true)
     */
    private $grippeTestControle;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="grippe_date_resultat", type="date", nullable=true)
     */
    private $grippeDateResultat;



    /**
     * Get grippeNumInclusion
     *
     * @return string 
     */
    public function getGrippeNumInclusion()
    {
        return $this->grippeNumInclusion;
    }

    /**
     * Set covidPaysProvenance
     *
     * @param string $covidPaysProvenance
     * @return Covid
     */
    public function setCovidPaysProvenance($covidPaysProvenance)
    {
        $this->covidPaysProvenance = $covidPaysProvenance;
    
        return $this;
    }

    /**
     * Get covidPaysProvenance
     *
     * @return string 
     */
    public function getCovidPaysProvenance()
    {
        return $this->covidPaysProvenance;
    }

    /**
     * Set datesaisie
     *
     * @param \DateTime $datesaisie
     * @return Covid
     */
    public function setDatesaisie($datesaisie)
    {
        $this->datesaisie = $datesaisie;
    
        return $this;
    }

    /**
     * Get datesaisie
     *
     * @return \DateTime 
     */
    public function getDatesaisie()
    {
        return $this->datesaisie;
    }

    /**
     * Set grippeAntibiotique
     *
     * @param boolean $grippeAntibiotique
     * @return Covid
     */
    public function setGrippeAntibiotique($grippeAntibiotique)
    {
        $this->grippeAntibiotique = $grippeAntibiotique;
    
        return $this;
    }

    /**
     * Get grippeAntibiotique
     *
     * @return boolean 
     */
    public function getGrippeAntibiotique()
    {
        return $this->grippeAntibiotique;
    }

    /**
     * Set grippeAntipaludique
     *
     * @param boolean $grippeAntipaludique
     * @return Covid
     */
    public function setGrippeAntipaludique($grippeAntipaludique)
    {
        $this->grippeAntipaludique = $grippeAntipaludique;
    
        return $this;
    }

    /**
     * Get grippeAntipaludique
     *
     * @return boolean 
     */
    public function getGrippeAntipaludique()
    {
        return $this->grippeAntipaludique;
    }

    /**
     * Set grippeAntipyretique
     *
     * @param boolean $grippeAntipyretique
     * @return Covid
     */
    public function setGrippeAntipyretique($grippeAntipyretique)
    {
        $this->grippeAntipyretique = $grippeAntipyretique;
    
        return $this;
    }

    /**
     * Get grippeAntipyretique
     *
     * @return boolean 
     */
    public function getGrippeAntipyretique()
    {
        return $this->grippeAntipyretique;
    }

    /**
     * Set grippeAntiviral
     *
     * @param boolean $grippeAntiviral
     * @return Covid
     */
    public function setGrippeAntiviral($grippeAntiviral)
    {
        $this->grippeAntiviral = $grippeAntiviral;
    
        return $this;
    }

    /**
     * Get grippeAntiviral
     *
     * @return boolean 
     */
    public function getGrippeAntiviral()
    {
        return $this->grippeAntiviral;
    }

    /**
     * Set grippeArthralgies
     *
     * @param string $grippeArthralgies
     * @return Covid
     */
    public function setGrippeArthralgies($grippeArthralgies)
    {
        $this->grippeArthralgies = $grippeArthralgies;
    
        return $this;
    }

    /**
     * Get grippeArthralgies
     *
     * @return string 
     */
    public function getGrippeArthralgies()
    {
        return $this->grippeArthralgies;
    }

    /**
     * Set grippeAsthenie
     *
     * @param boolean $grippeAsthenie
     * @return Covid
     */
    public function setGrippeAsthenie($grippeAsthenie)
    {
        $this->grippeAsthenie = $grippeAsthenie;
    
        return $this;
    }

    /**
     * Get grippeAsthenie
     *
     * @return boolean 
     */
    public function getGrippeAsthenie()
    {
        return $this->grippeAsthenie;
    }

    /**
     * Set grippeAsthme
     *
     * @param string $grippeAsthme
     * @return Covid
     */
    public function setGrippeAsthme($grippeAsthme)
    {
        $this->grippeAsthme = $grippeAsthme;
    
        return $this;
    }

    /**
     * Get grippeAsthme
     *
     * @return string 
     */
    public function getGrippeAsthme()
    {
        return $this->grippeAsthme;
    }

    /**
     * Set grippeAutreCoMorbidi
     *
     * @param string $grippeAutreCoMorbidi
     * @return Covid
     */
    public function setGrippeAutreCoMorbidi($grippeAutreCoMorbidi)
    {
        $this->grippeAutreCoMorbidi = $grippeAutreCoMorbidi;
    
        return $this;
    }

    /**
     * Get grippeAutreCoMorbidi
     *
     * @return string 
     */
    public function getGrippeAutreCoMorbidi()
    {
        return $this->grippeAutreCoMorbidi;
    }

    /**
     * Set grippeAutreExposion
     *
     * @param string $grippeAutreExposion
     * @return Covid
     */
    public function setGrippeAutreExposion($grippeAutreExposion)
    {
        $this->grippeAutreExposion = $grippeAutreExposion;
    
        return $this;
    }

    /**
     * Get grippeAutreExposion
     *
     * @return string 
     */
    public function getGrippeAutreExposion()
    {
        return $this->grippeAutreExposion;
    }

    /**
     * Set grippeCasSemblable
     *
     * @param string $grippeCasSemblable
     * @return Covid
     */
    public function setGrippeCasSemblable($grippeCasSemblable)
    {
        $this->grippeCasSemblable = $grippeCasSemblable;
    
        return $this;
    }

    /**
     * Get grippeCasSemblable
     *
     * @return string 
     */
    public function getGrippeCasSemblable()
    {
        return $this->grippeCasSemblable;
    }

    /**
     * Set grippeCephalee
     *
     * @param string $grippeCephalee
     * @return Covid
     */
    public function setGrippeCephalee($grippeCephalee)
    {
        $this->grippeCephalee = $grippeCephalee;
    
        return $this;
    }

    /**
     * Get grippeCephalee
     *
     * @return string 
     */
    public function getGrippeCephalee()
    {
        return $this->grippeCephalee;
    }

    /**
     * Set grippeClassification
     *
     * @param string $grippeClassification
     * @return Covid
     */
    public function setGrippeClassification($grippeClassification)
    {
        $this->grippeClassification = $grippeClassification;
    
        return $this;
    }

    /**
     * Get grippeClassification
     *
     * @return string 
     */
    public function getGrippeClassification()
    {
        return $this->grippeClassification;
    }

    /**
     * Set grippeCoMordCardio
     *
     * @param string $grippeCoMordCardio
     * @return Covid
     */
    public function setGrippeCoMordCardio($grippeCoMordCardio)
    {
        $this->grippeCoMordCardio = $grippeCoMordCardio;
    
        return $this;
    }

    /**
     * Get grippeCoMordCardio
     *
     * @return string 
     */
    public function getGrippeCoMordCardio()
    {
        return $this->grippeCoMordCardio;
    }

    /**
     * Set grippeCoMordRenal
     *
     * @param string $grippeCoMordRenal
     * @return Covid
     */
    public function setGrippeCoMordRenal($grippeCoMordRenal)
    {
        $this->grippeCoMordRenal = $grippeCoMordRenal;
    
        return $this;
    }

    /**
     * Get grippeCoMordRenal
     *
     * @return string 
     */
    public function getGrippeCoMordRenal()
    {
        return $this->grippeCoMordRenal;
    }

    /**
     * Set grippeConjonctivite
     *
     * @param boolean $grippeConjonctivite
     * @return Covid
     */
    public function setGrippeConjonctivite($grippeConjonctivite)
    {
        $this->grippeConjonctivite = $grippeConjonctivite;
    
        return $this;
    }

    /**
     * Get grippeConjonctivite
     *
     * @return boolean 
     */
    public function getGrippeConjonctivite()
    {
        return $this->grippeConjonctivite;
    }

    /**
     * Set grippeContactCovidConfLabo
     *
     * @param string $grippeContactCovidConfLabo
     * @return Covid
     */
    public function setGrippeContactCovidConfLabo($grippeContactCovidConfLabo)
    {
        $this->grippeContactCovidConfLabo = $grippeContactCovidConfLabo;
    
        return $this;
    }

    /**
     * Get grippeContactCovidConfLabo
     *
     * @return string 
     */
    public function getGrippeContactCovidConfLabo()
    {
        return $this->grippeContactCovidConfLabo;
    }

    /**
     * Set grippeConvulsion
     *
     * @param boolean $grippeConvulsion
     * @return Covid
     */
    public function setGrippeConvulsion($grippeConvulsion)
    {
        $this->grippeConvulsion = $grippeConvulsion;
    
        return $this;
    }

    /**
     * Get grippeConvulsion
     *
     * @return boolean 
     */
    public function getGrippeConvulsion()
    {
        return $this->grippeConvulsion;
    }

    /**
     * Set grippeDateDeces
     *
     * @param \DateTime $grippeDateDeces
     * @return Covid
     */
    public function setGrippeDateDeces($grippeDateDeces)
    {
        $this->grippeDateDeces = $grippeDateDeces;
    
        return $this;
    }

    /**
     * Get grippeDateDeces
     *
     * @return \DateTime 
     */
    public function getGrippeDateDeces()
    {
        return $this->grippeDateDeces;
    }

    /**
     * Set grippeDateEntreeCmr
     *
     * @param \DateTime $grippeDateEntreeCmr
     * @return Covid
     */
    public function setGrippeDateEntreeCmr($grippeDateEntreeCmr)
    {
        $this->grippeDateEntreeCmr = $grippeDateEntreeCmr;
    
        return $this;
    }

    /**
     * Get grippeDateEntreeCmr
     *
     * @return \DateTime 
     */
    public function getGrippeDateEntreeCmr()
    {
        return $this->grippeDateEntreeCmr;
    }

    /**
     * Set grippeDateExamen
     *
     * @param \DateTime $grippeDateExamen
     * @return Covid
     */
    public function setGrippeDateExamen($grippeDateExamen)
    {
        $this->grippeDateExamen = $grippeDateExamen;
    
        return $this;
    }

    /**
     * Get grippeDateExamen
     *
     * @return \DateTime 
     */
    public function getGrippeDateExamen()
    {
        return $this->grippeDateExamen;
    }

    /**
     * Set grippeDateHospitalisation
     *
     * @param \DateTime $grippeDateHospitalisation
     * @return Covid
     */
    public function setGrippeDateHospitalisation($grippeDateHospitalisation)
    {
        $this->grippeDateHospitalisation = $grippeDateHospitalisation;
    
        return $this;
    }

    /**
     * Get grippeDateHospitalisation
     *
     * @return \DateTime 
     */
    public function getGrippeDateHospitalisation()
    {
        return $this->grippeDateHospitalisation;
    }

    /**
     * Set grippeDateNaissance
     *
     * @param \DateTime $grippeDateNaissance
     * @return Covid
     */
    public function setGrippeDateNaissance($grippeDateNaissance)
    {
        $this->grippeDateNaissance = $grippeDateNaissance;
    
        return $this;
    }

    /**
     * Get grippeDateNaissance
     *
     * @return \DateTime 
     */
    public function getGrippeDateNaissance()
    {
        return $this->grippeDateNaissance;
    }

    /**
     * Set grippeDatePrelev
     *
     * @param \DateTime $grippeDatePrelev
     * @return Covid
     */
    public function setGrippeDatePrelev($grippeDatePrelev)
    {
        $this->grippeDatePrelev = $grippeDatePrelev;
    
        return $this;
    }

    /**
     * Get grippeDatePrelev
     *
     * @return \DateTime 
     */
    public function getGrippeDatePrelev()
    {
        return $this->grippeDatePrelev;
    }

    /**
     * Set grippeDatePrelevC1
     *
     * @param \DateTime $grippeDatePrelevC1
     * @return Covid
     */
    public function setGrippeDatePrelevC1($grippeDatePrelevC1)
    {
        $this->grippeDatePrelevC1 = $grippeDatePrelevC1;
    
        return $this;
    }

    /**
     * Get grippeDatePrelevC1
     *
     * @return \DateTime 
     */
    public function getGrippeDatePrelevC1()
    {
        return $this->grippeDatePrelevC1;
    }

    /**
     * Set grippeDatePremSymptome
     *
     * @param \DateTime $grippeDatePremSymptome
     * @return Covid
     */
    public function setGrippeDatePremSymptome($grippeDatePremSymptome)
    {
        $this->grippeDatePremSymptome = $grippeDatePremSymptome;
    
        return $this;
    }

    /**
     * Get grippeDatePremSymptome
     *
     * @return \DateTime 
     */
    public function getGrippeDatePremSymptome()
    {
        return $this->grippeDatePremSymptome;
    }

    /**
     * Set grippeDateReceptEchant
     *
     * @param \DateTime $grippeDateReceptEchant
     * @return Covid
     */
    public function setGrippeDateReceptEchant($grippeDateReceptEchant)
    {
        $this->grippeDateReceptEchant = $grippeDateReceptEchant;
    
        return $this;
    }

    /**
     * Get grippeDateReceptEchant
     *
     * @return \DateTime 
     */
    public function getGrippeDateReceptEchant()
    {
        return $this->grippeDateReceptEchant;
    }

    /**
     * Set grippeDecede
     *
     * @param boolean $grippeDecede
     * @return Covid
     */
    public function setGrippeDecede($grippeDecede)
    {
        $this->grippeDecede = $grippeDecede;
    
        return $this;
    }

    /**
     * Get grippeDecede
     *
     * @return boolean 
     */
    public function getGrippeDecede()
    {
        return $this->grippeDecede;
    }

    /**
     * Set grippeDiabete
     *
     * @param string $grippeDiabete
     * @return Covid
     */
    public function setGrippeDiabete($grippeDiabete)
    {
        $this->grippeDiabete = $grippeDiabete;
    
        return $this;
    }

    /**
     * Get grippeDiabete
     *
     * @return string 
     */
    public function getGrippeDiabete()
    {
        return $this->grippeDiabete;
    }

    /**
     * Set grippeDiagnostClinique
     *
     * @param string $grippeDiagnostClinique
     * @return Covid
     */
    public function setGrippeDiagnostClinique($grippeDiagnostClinique)
    {
        $this->grippeDiagnostClinique = $grippeDiagnostClinique;
    
        return $this;
    }

    /**
     * Get grippeDiagnostClinique
     *
     * @return string 
     */
    public function getGrippeDiagnostClinique()
    {
        return $this->grippeDiagnostClinique;
    }

    /**
     * Set grippeDiarrhee
     *
     * @param boolean $grippeDiarrhee
     * @return Covid
     */
    public function setGrippeDiarrhee($grippeDiarrhee)
    {
        $this->grippeDiarrhee = $grippeDiarrhee;
    
        return $this;
    }

    /**
     * Get grippeDiarrhee
     *
     * @return boolean 
     */
    public function getGrippeDiarrhee()
    {
        return $this->grippeDiarrhee;
    }

    /**
     * Set grippeDoulOreille
     *
     * @param string $grippeDoulOreille
     * @return Covid
     */
    public function setGrippeDoulOreille($grippeDoulOreille)
    {
        $this->grippeDoulOreille = $grippeDoulOreille;
    
        return $this;
    }

    /**
     * Get grippeDoulOreille
     *
     * @return string 
     */
    public function getGrippeDoulOreille()
    {
        return $this->grippeDoulOreille;
    }

    /**
     * Set grippeEchantApresDeces
     *
     * @param boolean $grippeEchantApresDeces
     * @return Covid
     */
    public function setGrippeEchantApresDeces($grippeEchantApresDeces)
    {
        $this->grippeEchantApresDeces = $grippeEchantApresDeces;
    
        return $this;
    }

    /**
     * Get grippeEchantApresDeces
     *
     * @return boolean 
     */
    public function getGrippeEchantApresDeces()
    {
        return $this->grippeEchantApresDeces;
    }

    /**
     * Set grippeEcouvGorge
     *
     * @param boolean $grippeEcouvGorge
     * @return Covid
     */
    public function setGrippeEcouvGorge($grippeEcouvGorge)
    {
        $this->grippeEcouvGorge = $grippeEcouvGorge;
    
        return $this;
    }

    /**
     * Get grippeEcouvGorge
     *
     * @return boolean 
     */
    public function getGrippeEcouvGorge()
    {
        return $this->grippeEcouvGorge;
    }

    /**
     * Set grippeEcouvNasopharynge
     *
     * @param boolean $grippeEcouvNasopharynge
     * @return Covid
     */
    public function setGrippeEcouvNasopharynge($grippeEcouvNasopharynge)
    {
        $this->grippeEcouvNasopharynge = $grippeEcouvNasopharynge;
    
        return $this;
    }

    /**
     * Get grippeEcouvNasopharynge
     *
     * @return boolean 
     */
    public function getGrippeEcouvNasopharynge()
    {
        return $this->grippeEcouvNasopharynge;
    }

    /**
     * Set grippeEnfant
     *
     * @param string $grippeEnfant
     * @return Covid
     */
    public function setGrippeEnfant($grippeEnfant)
    {
        $this->grippeEnfant = $grippeEnfant;
    
        return $this;
    }

    /**
     * Get grippeEnfant
     *
     * @return string 
     */
    public function getGrippeEnfant()
    {
        return $this->grippeEnfant;
    }

    /**
     * Set grippeEruptionCutanee
     *
     * @param boolean $grippeEruptionCutanee
     * @return Covid
     */
    public function setGrippeEruptionCutanee($grippeEruptionCutanee)
    {
        $this->grippeEruptionCutanee = $grippeEruptionCutanee;
    
        return $this;
    }

    /**
     * Get grippeEruptionCutanee
     *
     * @return boolean 
     */
    public function getGrippeEruptionCutanee()
    {
        return $this->grippeEruptionCutanee;
    }

    /**
     * Set grippeEssouflement
     *
     * @param boolean $grippeEssouflement
     * @return Covid
     */
    public function setGrippeEssouflement($grippeEssouflement)
    {
        $this->grippeEssouflement = $grippeEssouflement;
    
        return $this;
    }

    /**
     * Get grippeEssouflement
     *
     * @return boolean 
     */
    public function getGrippeEssouflement()
    {
        return $this->grippeEssouflement;
    }

    /**
     * Set grippeFormSanitaire
     *
     * @param string $grippeFormSanitaire
     * @return Covid
     */
    public function setGrippeFormSanitaire($grippeFormSanitaire)
    {
        $this->grippeFormSanitaire = $grippeFormSanitaire;
    
        return $this;
    }

    /**
     * Get grippeFormSanitaire
     *
     * @return string 
     */
    public function getGrippeFormSanitaire()
    {
        return $this->grippeFormSanitaire;
    }

    /**
     * Set grippeFreqCardiaque
     *
     * @param string $grippeFreqCardiaque
     * @return Covid
     */
    public function setGrippeFreqCardiaque($grippeFreqCardiaque)
    {
        $this->grippeFreqCardiaque = $grippeFreqCardiaque;
    
        return $this;
    }

    /**
     * Get grippeFreqCardiaque
     *
     * @return string 
     */
    public function getGrippeFreqCardiaque()
    {
        return $this->grippeFreqCardiaque;
    }

    /**
     * Set grippeFreqRespi
     *
     * @param string $grippeFreqRespi
     * @return Covid
     */
    public function setGrippeFreqRespi($grippeFreqRespi)
    {
        $this->grippeFreqRespi = $grippeFreqRespi;
    
        return $this;
    }

    /**
     * Get grippeFreqRespi
     *
     * @return string 
     */
    public function getGrippeFreqRespi()
    {
        return $this->grippeFreqRespi;
    }

    /**
     * Set grippeGueri
     *
     * @param boolean $grippeGueri
     * @return Covid
     */
    public function setGrippeGueri($grippeGueri)
    {
        $this->grippeGueri = $grippeGueri;
    
        return $this;
    }

    /**
     * Get grippeGueri
     *
     * @return boolean 
     */
    public function getGrippeGueri()
    {
        return $this->grippeGueri;
    }

    /**
     * Set grippeHeurePrelev
     *
     * @param \DateTime $grippeHeurePrelev
     * @return Covid
     */
    public function setGrippeHeurePrelev($grippeHeurePrelev)
    {
        $this->grippeHeurePrelev = $grippeHeurePrelev;
    
        return $this;
    }

    /**
     * Get grippeHeurePrelev
     *
     * @return \DateTime 
     */
    public function getGrippeHeurePrelev()
    {
        return $this->grippeHeurePrelev;
    }

    /**
     * Set grippeHeureReceptEchant
     *
     * @param \DateTime $grippeHeureReceptEchant
     * @return Covid
     */
    public function setGrippeHeureReceptEchant($grippeHeureReceptEchant)
    {
        $this->grippeHeureReceptEchant = $grippeHeureReceptEchant;
    
        return $this;
    }

    /**
     * Get grippeHeureReceptEchant
     *
     * @return \DateTime 
     */
    public function getGrippeHeureReceptEchant()
    {
        return $this->grippeHeureReceptEchant;
    }

    /**
     * Set grippeImmunoDepression
     *
     * @param string $grippeImmunoDepression
     * @return Covid
     */
    public function setGrippeImmunoDepression($grippeImmunoDepression)
    {
        $this->grippeImmunoDepression = $grippeImmunoDepression;
    
        return $this;
    }

    /**
     * Get grippeImmunoDepression
     *
     * @return string 
     */
    public function getGrippeImmunoDepression()
    {
        return $this->grippeImmunoDepression;
    }

    /**
     * Set grippeIncapaciteBoire
     *
     * @param boolean $grippeIncapaciteBoire
     * @return Covid
     */
    public function setGrippeIncapaciteBoire($grippeIncapaciteBoire)
    {
        $this->grippeIncapaciteBoire = $grippeIncapaciteBoire;
    
        return $this;
    }

    /**
     * Get grippeIncapaciteBoire
     *
     * @return boolean 
     */
    public function getGrippeIncapaciteBoire()
    {
        return $this->grippeIncapaciteBoire;
    }

    /**
     * Set grippeLethargieIncons
     *
     * @param boolean $grippeLethargieIncons
     * @return Covid
     */
    public function setGrippeLethargieIncons($grippeLethargieIncons)
    {
        $this->grippeLethargieIncons = $grippeLethargieIncons;
    
        return $this;
    }

    /**
     * Get grippeLethargieIncons
     *
     * @return boolean 
     */
    public function getGrippeLethargieIncons()
    {
        return $this->grippeLethargieIncons;
    }

    /**
     * Set grippeMalGorge
     *
     * @param string $grippeMalGorge
     * @return Covid
     */
    public function setGrippeMalGorge($grippeMalGorge)
    {
        $this->grippeMalGorge = $grippeMalGorge;
    
        return $this;
    }

    /**
     * Get grippeMalGorge
     *
     * @return string 
     */
    public function getGrippeMalGorge()
    {
        return $this->grippeMalGorge;
    }

    /**
     * Set grippeMalade
     *
     * @param boolean $grippeMalade
     * @return Covid
     */
    public function setGrippeMalade($grippeMalade)
    {
        $this->grippeMalade = $grippeMalade;
    
        return $this;
    }

    /**
     * Get grippeMalade
     *
     * @return boolean 
     */
    public function getGrippeMalade()
    {
        return $this->grippeMalade;
    }

    /**
     * Set grippeMyalgies
     *
     * @param string $grippeMyalgies
     * @return Covid
     */
    public function setGrippeMyalgies($grippeMyalgies)
    {
        $this->grippeMyalgies = $grippeMyalgies;
    
        return $this;
    }

    /**
     * Get grippeMyalgies
     *
     * @return string 
     */
    public function getGrippeMyalgies()
    {
        return $this->grippeMyalgies;
    }

    /**
     * Set grippeNbreJrHospitalisation
     *
     * @param integer $grippeNbreJrHospitalisation
     * @return Covid
     */
    public function setGrippeNbreJrHospitalisation($grippeNbreJrHospitalisation)
    {
        $this->grippeNbreJrHospitalisation = $grippeNbreJrHospitalisation;
    
        return $this;
    }

    /**
     * Get grippeNbreJrHospitalisation
     *
     * @return integer 
     */
    public function getGrippeNbreJrHospitalisation()
    {
        return $this->grippeNbreJrHospitalisation;
    }

    /**
     * Set grippeNegatifFievre
     *
     * @param string $grippeNegatifFievre
     * @return Covid
     */
    public function setGrippeNegatifFievre($grippeNegatifFievre)
    {
        $this->grippeNegatifFievre = $grippeNegatifFievre;
    
        return $this;
    }

    /**
     * Get grippeNegatifFievre
     *
     * @return string 
     */
    public function getGrippeNegatifFievre()
    {
        return $this->grippeNegatifFievre;
    }

    /**
     * Set grippeNomPrenom
     *
     * @param string $grippeNomPrenom
     * @return Covid
     */
    public function setGrippeNomPrenom($grippeNomPrenom)
    {
        $this->grippeNomPrenom = $grippeNomPrenom;
    
        return $this;
    }

    /**
     * Get grippeNomPrenom
     *
     * @return string 
     */
    public function getGrippeNomPrenom()
    {
        return $this->grippeNomPrenom;
    }

    /**
     * Set grippeNumInclusionC1
     *
     * @param string $grippeNumInclusionC1
     * @return Covid
     */
    public function setGrippeNumInclusionC1($grippeNumInclusionC1)
    {
        $this->grippeNumInclusionC1 = $grippeNumInclusionC1;
    
        return $this;
    }

    /**
     * Get grippeNumInclusionC1
     *
     * @return string 
     */
    public function getGrippeNumInclusionC1()
    {
        return $this->grippeNumInclusionC1;
    }

    /**
     * Set grippeParent
     *
     * @param string $grippeParent
     * @return Covid
     */
    public function setGrippeParent($grippeParent)
    {
        $this->grippeParent = $grippeParent;
    
        return $this;
    }

    /**
     * Get grippeParent
     *
     * @return string 
     */
    public function getGrippeParent()
    {
        return $this->grippeParent;
    }

    /**
     * Set grippePaysCovid
     *
     * @param boolean $grippePaysCovid
     * @return Covid
     */
    public function setGrippePaysCovid($grippePaysCovid)
    {
        $this->grippePaysCovid = $grippePaysCovid;
    
        return $this;
    }

    /**
     * Get grippePaysCovid
     *
     * @return boolean 
     */
    public function getGrippePaysCovid()
    {
        return $this->grippePaysCovid;
    }

    /**
     * Set grippePoids
     *
     * @param integer $grippePoids
     * @return Covid
     */
    public function setGrippePoids($grippePoids)
    {
        $this->grippePoids = $grippePoids;
    
        return $this;
    }

    /**
     * Get grippePoids
     *
     * @return integer 
     */
    public function getGrippePoids()
    {
        return $this->grippePoids;
    }

    /**
     * Set grippePositifFievre
     *
     * @param string $grippePositifFievre
     * @return Covid
     */
    public function setGrippePositifFievre($grippePositifFievre)
    {
        $this->grippePositifFievre = $grippePositifFievre;
    
        return $this;
    }

    /**
     * Get grippePositifFievre
     *
     * @return string 
     */
    public function getGrippePositifFievre()
    {
        return $this->grippePositifFievre;
    }

    /**
     * Set grippePreciser
     *
     * @param string $grippePreciser
     * @return Covid
     */
    public function setGrippePreciser($grippePreciser)
    {
        $this->grippePreciser = $grippePreciser;
    
        return $this;
    }

    /**
     * Get grippePreciser
     *
     * @return string 
     */
    public function getGrippePreciser()
    {
        return $this->grippePreciser;
    }

    /**
     * Set grippePreciserAutreExpo
     *
     * @param string $grippePreciserAutreExpo
     * @return Covid
     */
    public function setGrippePreciserAutreExpo($grippePreciserAutreExpo)
    {
        $this->grippePreciserAutreExpo = $grippePreciserAutreExpo;
    
        return $this;
    }

    /**
     * Get grippePreciserAutreExpo
     *
     * @return string 
     */
    public function getGrippePreciserAutreExpo()
    {
        return $this->grippePreciserAutreExpo;
    }

    /**
     * Set grippePrenom
     *
     * @param string $grippePrenom
     * @return Covid
     */
    public function setGrippePrenom($grippePrenom)
    {
        $this->grippePrenom = $grippePrenom;
    
        return $this;
    }

    /**
     * Get grippePrenom
     *
     * @return string 
     */
    public function getGrippePrenom()
    {
        return $this->grippePrenom;
    }

    /**
     * Set grippeRegionCmr
     *
     * @param string $grippeRegionCmr
     * @return Covid
     */
    public function setGrippeRegionCmr($grippeRegionCmr)
    {
        $this->grippeRegionCmr = $grippeRegionCmr;
    
        return $this;
    }

    /**
     * Get grippeRegionCmr
     *
     * @return string 
     */
    public function getGrippeRegionCmr()
    {
        return $this->grippeRegionCmr;
    }

    /**
     * Set grippeRespSiflante
     *
     * @param boolean $grippeRespSiflante
     * @return Covid
     */
    public function setGrippeRespSiflante($grippeRespSiflante)
    {
        $this->grippeRespSiflante = $grippeRespSiflante;
    
        return $this;
    }

    /**
     * Get grippeRespSiflante
     *
     * @return boolean 
     */
    public function getGrippeRespSiflante()
    {
        return $this->grippeRespSiflante;
    }

    /**
     * Set grippeResultGenotypage
     *
     * @param string $grippeResultGenotypage
     * @return Covid
     */
    public function setGrippeResultGenotypage($grippeResultGenotypage)
    {
        $this->grippeResultGenotypage = $grippeResultGenotypage;
    
        return $this;
    }

    /**
     * Get grippeResultGenotypage
     *
     * @return string 
     */
    public function getGrippeResultGenotypage()
    {
        return $this->grippeResultGenotypage;
    }

    /**
     * Set grippeResultPcr
     *
     * @param string $grippeResultPcr
     * @return Covid
     */
    public function setGrippeResultPcr($grippeResultPcr)
    {
        $this->grippeResultPcr = $grippeResultPcr;
    
        return $this;
    }

    /**
     * Get grippeResultPcr
     *
     * @return string 
     */
    public function getGrippeResultPcr()
    {
        return $this->grippeResultPcr;
    }

    /**
     * Set grippeResultPcrC1
     *
     * @param string $grippeResultPcrC1
     * @return Covid
     */
    public function setGrippeResultPcrC1($grippeResultPcrC1)
    {
        $this->grippeResultPcrC1 = $grippeResultPcrC1;
    
        return $this;
    }

    /**
     * Get grippeResultPcrC1
     *
     * @return string 
     */
    public function getGrippeResultPcrC1()
    {
        return $this->grippeResultPcrC1;
    }

    /**
     * Set grippeRhinorrhee
     *
     * @param boolean $grippeRhinorrhee
     * @return Covid
     */
    public function setGrippeRhinorrhee($grippeRhinorrhee)
    {
        $this->grippeRhinorrhee = $grippeRhinorrhee;
    
        return $this;
    }

    /**
     * Get grippeRhinorrhee
     *
     * @return boolean 
     */
    public function getGrippeRhinorrhee()
    {
        return $this->grippeRhinorrhee;
    }

    /**
     * Set grippeSignAutre
     *
     * @param boolean $grippeSignAutre
     * @return Covid
     */
    public function setGrippeSignAutre($grippeSignAutre)
    {
        $this->grippeSignAutre = $grippeSignAutre;
    
        return $this;
    }

    /**
     * Get grippeSignAutre
     *
     * @return boolean 
     */
    public function getGrippeSignAutre()
    {
        return $this->grippeSignAutre;
    }

    /**
     * Set grippeSo2
     *
     * @param string $grippeSo2
     * @return Covid
     */
    public function setGrippeSo2($grippeSo2)
    {
        $this->grippeSo2 = $grippeSo2;
    
        return $this;
    }

    /**
     * Get grippeSo2
     *
     * @return string 
     */
    public function getGrippeSo2()
    {
        return $this->grippeSo2;
    }

    /**
     * Set grippeSousAntipyretique
     *
     * @param boolean $grippeSousAntipyretique
     * @return Covid
     */
    public function setGrippeSousAntipyretique($grippeSousAntipyretique)
    {
        $this->grippeSousAntipyretique = $grippeSousAntipyretique;
    
        return $this;
    }

    /**
     * Get grippeSousAntipyretique
     *
     * @return boolean 
     */
    public function getGrippeSousAntipyretique()
    {
        return $this->grippeSousAntipyretique;
    }

    /**
     * Set grippeSousTypeFievre
     *
     * @param string $grippeSousTypeFievre
     * @return Covid
     */
    public function setGrippeSousTypeFievre($grippeSousTypeFievre)
    {
        $this->grippeSousTypeFievre = $grippeSousTypeFievre;
    
        return $this;
    }

    /**
     * Get grippeSousTypeFievre
     *
     * @return string 
     */
    public function getGrippeSousTypeFievre()
    {
        return $this->grippeSousTypeFievre;
    }

    /**
     * Set grippeStatutCas
     *
     * @param string $grippeStatutCas
     * @return Covid
     */
    public function setGrippeStatutCas($grippeStatutCas)
    {
        $this->grippeStatutCas = $grippeStatutCas;
    
        return $this;
    }

    /**
     * Get grippeStatutCas
     *
     * @return string 
     */
    public function getGrippeStatutCas()
    {
        return $this->grippeStatutCas;
    }

    /**
     * Set grippeTelPatient
     *
     * @param string $grippeTelPatient
     * @return Covid
     */
    public function setGrippeTelPatient($grippeTelPatient)
    {
        $this->grippeTelPatient = $grippeTelPatient;
    
        return $this;
    }

    /**
     * Get grippeTelPatient
     *
     * @return string 
     */
    public function getGrippeTelPatient()
    {
        return $this->grippeTelPatient;
    }

    /**
     * Set grippeTemperature
     *
     * @param float $grippeTemperature
     * @return Covid
     */
    public function setGrippeTemperature($grippeTemperature)
    {
        $this->grippeTemperature = $grippeTemperature;
    
        return $this;
    }

    /**
     * Get grippeTemperature
     *
     * @return float 
     */
    public function getGrippeTemperature()
    {
        return $this->grippeTemperature;
    }

    /**
     * Set grippeTirageSousCostal
     *
     * @param boolean $grippeTirageSousCostal
     * @return Covid
     */
    public function setGrippeTirageSousCostal($grippeTirageSousCostal)
    {
        $this->grippeTirageSousCostal = $grippeTirageSousCostal;
    
        return $this;
    }

    /**
     * Get grippeTirageSousCostal
     *
     * @return boolean 
     */
    public function getGrippeTirageSousCostal()
    {
        return $this->grippeTirageSousCostal;
    }

    /**
     * Set grippeToux
     *
     * @param boolean $grippeToux
     * @return Covid
     */
    public function setGrippeToux($grippeToux)
    {
        $this->grippeToux = $grippeToux;
    
        return $this;
    }

    /**
     * Get grippeToux
     *
     * @return boolean 
     */
    public function getGrippeToux()
    {
        return $this->grippeToux;
    }

    /**
     * Set grippeTypeCas
     *
     * @param string $grippeTypeCas
     * @return Covid
     */
    public function setGrippeTypeCas($grippeTypeCas)
    {
        $this->grippeTypeCas = $grippeTypeCas;
    
        return $this;
    }

    /**
     * Get grippeTypeCas
     *
     * @return string 
     */
    public function getGrippeTypeCas()
    {
        return $this->grippeTypeCas;
    }

    /**
     * Set grippeTypePrelevement
     *
     * @param string $grippeTypePrelevement
     * @return Covid
     */
    public function setGrippeTypePrelevement($grippeTypePrelevement)
    {
        $this->grippeTypePrelevement = $grippeTypePrelevement;
    
        return $this;
    }

    /**
     * Get grippeTypePrelevement
     *
     * @return string 
     */
    public function getGrippeTypePrelevement()
    {
        return $this->grippeTypePrelevement;
    }

    /**
     * Set grippeVille
     *
     * @param string $grippeVille
     * @return Covid
     */
    public function setGrippeVille($grippeVille)
    {
        $this->grippeVille = $grippeVille;
    
        return $this;
    }

    /**
     * Get grippeVille
     *
     * @return string 
     */
    public function getGrippeVille()
    {
        return $this->grippeVille;
    }

    /**
     * Set grippeVomissIncoherci
     *
     * @param boolean $grippeVomissIncoherci
     * @return Covid
     */
    public function setGrippeVomissIncoherci($grippeVomissIncoherci)
    {
        $this->grippeVomissIncoherci = $grippeVomissIncoherci;
    
        return $this;
    }

    /**
     * Get grippeVomissIncoherci
     *
     * @return boolean 
     */
    public function getGrippeVomissIncoherci()
    {
        return $this->grippeVomissIncoherci;
    }

    /**
     * Set grippeVomissement
     *
     * @param boolean $grippeVomissement
     * @return Covid
     */
    public function setGrippeVomissement($grippeVomissement)
    {
        $this->grippeVomissement = $grippeVomissement;
    
        return $this;
    }

    /**
     * Get grippeVomissement
     *
     * @return boolean 
     */
    public function getGrippeVomissement()
    {
        return $this->grippeVomissement;
    }

    /**
     * Set grippeYeuxRouges
     *
     * @param boolean $grippeYeuxRouges
     * @return Covid
     */
    public function setGrippeYeuxRouges($grippeYeuxRouges)
    {
        $this->grippeYeuxRouges = $grippeYeuxRouges;
    
        return $this;
    }

    /**
     * Get grippeYeuxRouges
     *
     * @return boolean 
     */
    public function getGrippeYeuxRouges()
    {
        return $this->grippeYeuxRouges;
    }

    /**
     * Set orgunit
     *
     * @param string $orgunit
     * @return Covid
     */
    public function setOrgunit($orgunit)
    {
        $this->orgunit = $orgunit;
    
        return $this;
    }

    /**
     * Get orgunit
     *
     * @return string 
     */
    public function getOrgunit()
    {
        return $this->orgunit;
    }

    /**
     * Set sexe
     *
     * @param string $sexe
     * @return Covid
     */
    public function setSexe($sexe)
    {
        $this->sexe = $sexe;
    
        return $this;
    }

    /**
     * Get sexe
     *
     * @return string 
     */
    public function getSexe()
    {
        return $this->sexe;
    }

    /**
     * Set vaccinationGrippeFievre
     *
     * @param boolean $vaccinationGrippeFievre
     * @return Covid
     */
    public function setVaccinationGrippeFievre($vaccinationGrippeFievre)
    {
        $this->vaccinationGrippeFievre = $vaccinationGrippeFievre;
    
        return $this;
    }

    /**
     * Get vaccinationGrippeFievre
     *
     * @return boolean 
     */
    public function getVaccinationGrippeFievre()
    {
        return $this->vaccinationGrippeFievre;
    }

    /**
     * Set sms
     *
     * @param integer $sms
     * @return Covid
     */
    public function setSms($sms)
    {
        $this->sms = $sms;
    
        return $this;
    }

    /**
     * Get sms
     *
     * @return integer 
     */
    public function getSms()
    {
        return $this->sms;
    }

    /**
     * Set grippeStridor
     *
     * @param boolean $grippeStridor
     * @return Covid
     */
    public function setGrippeStridor($grippeStridor)
    {
        $this->grippeStridor = $grippeStridor;
    
        return $this;
    }

    /**
     * Get grippeStridor
     *
     * @return boolean 
     */
    public function getGrippeStridor()
    {
        return $this->grippeStridor;
    }

    /**
     * Set grippeTestControle
     *
     * @param boolean $grippeTestControle
     * @return Covid
     */
    public function setGrippeTestControle($grippeTestControle)
    {
        $this->grippeTestControle = $grippeTestControle;
    
        return $this;
    }

    /**
     * Get grippeTestControle
     *
     * @return boolean 
     */
    public function getGrippeTestControle()
    {
        return $this->grippeTestControle;
    }

    /**
     * Set grippeDateResultat
     *
     * @param \DateTime $grippeDateResultat
     * @return Covid
     */
    public function setGrippeDateResultat($grippeDateResultat)
    {
        $this->grippeDateResultat = $grippeDateResultat;
    
        return $this;
    }

    /**
     * Get grippeDateResultat
     *
     * @return \DateTime 
     */
    public function getGrippeDateResultat()
    {
        return $this->grippeDateResultat;
    }
}