<?php

include APPLICATION_PATH . '/DAO/UtilisateurDAO.php';
include APPLICATION_PATH . '/DAO/ProfilDAO.php';
include APPLICATION_PATH . '/DAO/LogDAO.php';
include APPLICATION_PATH . '/DAO/PersonneDAO.php';
include PUBLIC_PATH . '/Fonctions/Fonction.php';

class IndexController extends Zend_Controller_Action
{

    public function init()
    {
        header('Access-Control-Allow-Origin: *');
    }

    public function indexAction()
    {
        // action body
        $profilDAO = new ProfilDAO();
            $profils = $profilDAO->lister();
            $this->view->listeProfils = $profils;
    }

    public function connexionAction()
    {
       $login = isset($_POST["login"])?  $_POST["login"] : null;
       $password = isset($_POST['password'])? sha1(md5($_POST["password"])) : null;
       $utilisateurDao = new UtilisateurDAO();
       if ( $user =  $utilisateurDao->getUtilisateurLoginPassword($login, $password)){
           session_cache_limiter('private_no_expire');
           session_cache_expire(60);
           session_start();
           $_SESSION["idUtilisateur"] = $user->getIdUtilisateur();
           $_SESSION["nomUtilisateur"] = $user->getIdpersonne()->getNom();
           $_SESSION["orgunit"] = $user->getIdprofil()->getOrgunit();
            //Module d'enregistrement des logs 
            try {
                $f = new Fonction();
               
                $descr = "Connexion de l'utilisateur " . $user->getIdpersonne()->getNom() . ", dont le login est " . $user->getLogin() . "";
                
                $f->EnregistrerLog($descr, $user);
                
            } catch (Exception $exc) {

            }
           echo json_encode(array("type" => "success"));
       }else{
           echo json_encode(array("type" => "error"));
       }
       exit();
       
    }

    public function deconnexionAction()
    {
            
        session_start();
        if ( isset($_SESSION["idUtilisateur"])){
            //Module d'enregistrement des logs  
            $idUser = $_SESSION["idUtilisateur"];
            $UserDAO = new UtilisateurDAO();
            $user = new Application\Models\Utilisateur();
            $user = $UserDAO->getUtilisateurById($idUser);
            
            try {
                $f = new Fonction();
               
                $descr = "Deconnexion de l'utilisateur " . $user->getIdpersonne()->getNom() . ", dont le login est " . $user->getLogin() . "";
                
                $f->EnregistrerLog($descr, $user);
                
            } catch (Exception $exc) {

            }
            
            $_SESSION = array();
        }
        
        session_destroy();
        $this->_helper->redirector('index' , 'Index');
    }



}







