$(document).ready(function() {
    var table = $('#classictable').DataTable( {
        lengthChange: false,
        buttons: [ 'copy', 'excel', 'pdf', 'colvis' ]
    } );
 
    table.buttons().container()
        .appendTo( '#classictable_wrapper .col-sm-6:eq(0)' );


    $("#chkopt2").click(function() {
        openCloseBox();
    });
} );


/**Retourne la valeur du select selectId*/
function getSelectValue(selectId)
{
    /**On récupère l'élement html <select>*/
    var selectElmt = document.getElementById(selectId);
    /**
    selectElmt.options correspond au tableau des balises <option> du select
    selectElmt.selectedIndex correspond à l'index du tableau options qui est actuellement sélectionné
    */
    return selectElmt.options[selectElmt.selectedIndex].value;
}


function  recalculateAbn()
{
    //$("#loadueclass").addClass("fa fa-spinner fa-spin");
    formule = getSelectValue("formule");
    months = $('input[name=months]:checked').val() 
    var sThisVal = "";
    
    $('input:checkbox.optionchk').each(function () {
       sThisVal += (this.checked ? $(this).val()+"-" : "");
    });
    
    $.ajax({
        // chargement du fichier externe monfichier-ajax.php 
        url      : "application/ajax/getTotalAbn.php",
        // Passage des données au fichier externe (ici le nom cliqué)  
        //data     : {NomEleve: "M3B"}, 
        data     : {Formule: formule, Months: months, Options: sThisVal},
        cache    : false,
        dataType : "json",
        error    : function(request, error) { // Info Debuggage si erreur         
                     //alert("Erreur : responseText: "+request.responseText);
                   },
        success  : function(data) {  
                     // Informe l'utilisateur que l'opération est terminé et renvoie le résultat
                     $("#Mnt_forml_val").html(data.priceforml);
                     $("#Mnt_Opt_val").html(data.priceopt);
                     $("#Mnt_Abn_val").html(data.pricetotal);
                   }, 
        complete    : function() { // Info Debuggage si erreur         
                     //$("#loadueclass").removeClass("fa fa-spinner fa-spin");
                   }      
     });
    //---
    return false; 
}

function  recalculateTotalMat()
{
    //$("#loadueclass").addClass("fa fa-spinner fa-spin");
    othermaterial = getSelectValue("othermaterial");
    ventedecodeur = $('input[name=ventedecodeur]:checked').val() 
    
    
    $.ajax({
        // chargement du fichier externe monfichier-ajax.php 
        url      : "application/ajax/getTotalMat.php",
        // Passage des données au fichier externe (ici le nom cliqué)  
        //data     : {NomEleve: "M3B"}, 
        data     : {OMat: othermaterial, VtDeco: ventedecodeur},
        cache    : false,
        dataType : "json",
        error    : function(request, error) { // Info Debuggage si erreur         
                     //alert("Erreur : responseText: "+request.responseText);
                   },
        success  : function(data) {  
                     // Informe l'utilisateur que l'opération est terminé et renvoie le résultat
                     $("#prix_decodeur").html(data.prix_decodeur);
                     $("#prix_parabole").html(data.prix_parabole);
                     $("#prix_autre").html(data.prix_autre);
                     $("#prix_total").html(data.prix_total);
                   }, 
        complete    : function() { // Info Debuggage si erreur         
                     //$("#loadueclass").removeClass("fa fa-spinner fa-spin");
                   }      
     });
    //---
    return false; 
}


function getPaymentBox(idFacture)
{
    
    $.ajax({
        // chargement du fichier externe monfichier-ajax.php 
        url      : "application/ajax/savePayment.php",
        // Passage des données au fichier externe (ici le nom cliqué)  
        //data     : {NomEleve: "M3B"}, 
        data     : {Facture: idFacture},
        cache    : false,
        dataType : "json",
        error    : function(request, error) { // Info Debuggage si erreur         
                     //alert("Erreur : responseText: "+request.responseText);
                   },
        success  : function(data) {  
                     // Informe l'utilisateur que l'opération est terminé et renvoie le résultat
                     $("#divhtmlpayment").html(data.divhtmlpayment);
                   }, 
        complete    : function() { // Info Debuggage si erreur         
                     //$("#loadueclass").removeClass("fa fa-spinner fa-spin");
                   }      
     });
    //---
    return false; 
}


// statistique de l'abonnement
function  getStat(){
    
   PointCode = getSelectValue("pos");
   agentCode = getSelectValue("sale_agent_code");
   userId=getSelectValue("user");
    
   
    $.ajax({
        // chargement du fichier externe monfichier-ajax.php 
        url      : "application/ajax/getAbonnement.php",
        // Passage des données au fichier externe (ici le nom cliqué)  
         
        data     : {Point: PointCode,Agent: agentCode,User: userId },
        cache    : false,
      
        dataType : "json",
        error    : function(request,error){
                     
                 // Info Debuggage si erreur         
                     alert("Erreur : responseText: "+request.responseText);
                   },
        success  : function(data) {
                    
                     // Informe l'utilisateur que l'opération est terminé et renvoie le résultat
                     $("#abo").html(data.res);
                     //$("#pt").val(data.prix_total);
                   }, 
        complete    : function() { // Info Debuggage si erreur         
                     //$("#loadueclass").removeClass("fa fa-spinner fa-spin");
                   }      
     });
    //---
    return false; 
    
}

// statistique des factures

function  getStatBill(){
    debut = $("#debut").val();
    fin = $("#debut").val();
   // alert(debut); return false;
   
   PointCode = getSelectValue("pos");
   idChoice = getSelectValue("critere");
   
    
    //alert("choixi "+dChoice+" point de vente "+PointCode); return false;
   
    $.ajax({
        // chargement du fichier externe monfichier-ajax.php 
        url      : "application/ajax/getBill.php",
        // Passage des données au fichier externe (ici le nom cliqué)  
         
        data     : {Point: PointCode,Choise: idChoice,Debut: debut,Fin: fin},
        cache    : false,
      
        dataType : "json",
        error    : function(request,error){
                     
                 // Info Debuggage si erreur         
                     alert("Erreur : responseText: "+request.responseText);
                   },
        success  : function(data) {
                    
                     // Informe l'utilisateur que l'opération est terminé et renvoie le résultat
                     $("#abo").html(data.res);
                     //$("#pt").val(data.prix_total);
                   }, 
        complete    : function() { // Info Debuggage si erreur         
                     //$("#loadueclass").removeClass("fa fa-spinner fa-spin");
                   }      
     });
    //---
    return false; 
    
}

function  getStatSales(){
    
   PointCode = getSelectValue("pos");
   idCat = getSelectValue("cat");
   
    
    //alert("choixi "+dChoice+" point de vente "+PointCode); return false;
   
    $.ajax({
        // chargement du fichier externe monfichier-ajax.php 
        url      : "application/ajax/getSalles.php",
        // Passage des données au fichier externe (ici le nom cliqué)  
         
        data     : {Point: PointCode,Cat: idCat},
        cache    : false,
      
        dataType : "json",
        error    : function(request,error){
                     
                 // Info Debuggage si erreur         
                     alert("Erreur : responseText: "+request.responseText);
                   },
        success  : function(data) {
                    
                     // Informe l'utilisateur que l'opération est terminé et renvoie le résultat
                     $("#abo").html(data.res);
                     //$("#pt").val(data.prix_total);
                   }, 
        complete    : function() { // Info Debuggage si erreur         
                     //$("#loadueclass").removeClass("fa fa-spinner fa-spin");
                   }      
     });
    //---
    return false; 
    
}

function getPaymentBox(idFacture)
{
    boxId = "divhtmlpayment";
    if ($("#"+boxId).is(":visible")) //--- visible (rendre invisible)
    {
        $("#"+boxId).addClass("hidden");
    }
    else //--- visible
    {
        $.ajax({
        // chargement du fichier externe monfichier-ajax.php 
        url      : "application/ajax/getPaymentBox.php",
        // Passage des données au fichier externe (ici le nom cliqué)  
        //data     : {NomEleve: "M3B"}, 
        data     : {Facture: idFacture},
        cache    : false,
        dataType : "json",
        error    : function(request, error) { // Info Debuggage si erreur         
                     //alert("Erreur : responseText: "+request.responseText);
                   },
        success  : function(data) {  
                     // Informe l'utilisateur que l'opération est terminé et renvoie le résultat
                     $("#divhtmlpayment").html(data.divhtmlpayment);
                     $("#"+boxId).removeClass("hidden");
                   }, 
        complete    : function() { // Info Debuggage si erreur         
                     //$("#loadueclass").removeClass("fa fa-spinner fa-spin");
                   }      
     });
    }
    
    //---
    return false; 
}


function savePayment(idFacture)
{
    amountpaid = $("#amountpaid").val();
    //alert("test:"+amountpaid);return false;
    var r = confirm("Confirmez-vous le montant de "+amountpaid+" F CFA?");
    if (r == true) {
        $.ajax({
            // chargement du fichier externe monfichier-ajax.php 
            url      : "application/ajax/savePayment.php",
            // Passage des données au fichier externe (ici le nom cliqué)  
            //data     : {NomEleve: "M3B"}, 
            data     : {Amount: amountpaid, Facture: idFacture},
            cache    : false,
            dataType : "json",
            error    : function(request, error) { // Info Debuggage si erreur         
                         //alert("Erreur : responseText: "+request.responseText);
                       },
            success  : function(data) {  
                         // Informe l'utilisateur que l'opération est terminé et renvoie le résultat
                         if (data.status === "OK")
                         {
                            $("#simpletable2").html(data.simpletable2);
                            $("#totalpaid").html(data.totalpaid);
                            $("#restpaid").html(data.restpaid);
                            $("#divhtmlpayment").addClass("hidden");
                         }
                         else
                         {
                             alert(data.msg);
                         }
                       }, 
            complete    : function() { // Info Debuggage si erreur         
                         //$("#loadueclass").removeClass("fa fa-spinner fa-spin");
                       }      
         });
    }
    //---
    return false; 
}

function addToBill()
{
    productPointCode = getSelectValue("productPointCode");
    qty = $("#quantity").val();
    pu = $("#pu").val();
    
    $.ajax({
        // chargement du fichier externe monfichier-ajax.php 
        url      : "application/ajax/addToBill.php",
        // Passage des données au fichier externe (ici le nom cliqué)  
        //data     : {NomEleve: "M3B"}, 
        data     : {Product: productPointCode, QTY: qty, PU: pu},
        cache    : false,
        dataType : "json",
        error    : function(request, error) { // Info Debuggage si erreur         
                     //alert("Erreur : responseText: "+request.responseText);
                   },
        success  : function(data) {  
                     // Informe l'utilisateur que l'opération est terminé et renvoie le résultat
                     $("#divlistbillproducts").html(data.divlistbillproducts);
                     $("#divlistbillproducts").removeClass("hidden").addClass(data.divclass);
                   }, 
        complete    : function() { // Info Debuggage si erreur         
                     //$("#loadueclass").removeClass("fa fa-spinner fa-spin");
                   }      
     });
    //---
    return false; 
}


function editToBill(originalProdPtId)
{
    productPointCode = getSelectValue("productPointCode");
    qty = $("#quantity").val();
    pu = $("#pu").val();
    
    $.ajax({
        // chargement du fichier externe monfichier-ajax.php 
        url      : "application/ajax/editToBill.php",
        // Passage des données au fichier externe (ici le nom cliqué)  
        //data     : {NomEleve: "M3B"}, 
        data     : {Product: productPointCode, QTY: qty, PU: pu, OrProduct: originalProdPtId},
        cache    : false,
        dataType : "json",
        error    : function(request, error) { // Info Debuggage si erreur         
                     //alert("Erreur : responseText: "+request.responseText);
                   },
        success  : function(data) {  
                     // Informe l'utilisateur que l'opération est terminé et renvoie le résultat
                     $("#divlistbillproducts").html(data.divlistbillproducts);
                     $("#divlistbillproducts").removeClass("hidden").addClass(data.divclass);
                     $("#btn_zone").html(data.btn_zone);
                   }, 
        complete    : function() { // Info Debuggage si erreur         
                     //$("#loadueclass").removeClass("fa fa-spinner fa-spin");
                   }      
     });
    //---
    return false; 
}

function editBillLine(prodptId)
{
    
    $.ajax({
        // chargement du fichier externe monfichier-ajax.php 
        url      : "application/ajax/editBillLine.php",
        // Passage des données au fichier externe (ici le nom cliqué)  
        //data     : {NomEleve: "M3B"}, 
        data     : {Product: prodptId},
        cache    : false,
        dataType : "json",
        error    : function(request, error) { // Info Debuggage si erreur         
                     //alert("Erreur : responseText: "+request.responseText);
                   },
        success  : function(data) {  
                     // Informe l'utilisateur que l'opération est terminé et renvoie le résultat
                     $("#productPointCode").val(data.product); // productPointCode
                     $("#quantity").val(data.qte);
                     $("#pu").val(data.prix_unitaire);
                     $("#pt").val(data.prix_total);
                     $("#btn_zone").html(data.btn_zone);
                   }, 
        complete    : function() { // Info Debuggage si erreur         
                     //$("#loadueclass").removeClass("fa fa-spinner fa-spin");
                   }      
     });
    //---
    return false; 
}


function deleteBillLine(prodptId)
{
    var r = confirm("Voulez-vous vraiment supprimer ce produit de la facture?");
    if (r == true) {
        $.ajax({
        // chargement du fichier externe monfichier-ajax.php 
        url      : "application/ajax/deleteBillLine.php",
        // Passage des données au fichier externe (ici le nom cliqué)  
        //data     : {NomEleve: "M3B"}, 
        data     : {Product: prodptId},
        cache    : false,
        dataType : "json",
        error    : function(request, error) { // Info Debuggage si erreur         
                     //alert("Erreur : responseText: "+request.responseText);
                   },
        success  : function(data) {  
                     // Informe l'utilisateur que l'opération est terminé et renvoie le résultat
                     $("#divlistbillproducts").html(data.divlistbillproducts);
                   }, 
        complete    : function() { // Info Debuggage si erreur         
                     //$("#loadueclass").removeClass("fa fa-spinner fa-spin");
                   }      
     });
    }
    //---
    return false; 
}

function getProductDetails()
{
    //$("#loadueclass").addClass("fa fa-spinner fa-spin");
    productPointCode = getSelectValue("productPointCode");
    qty = $("#quantity").val();
    
    $.ajax({
        // chargement du fichier externe monfichier-ajax.php 
        url      : "<?php echo $this->url(array('controller' => 'Abonnement', 'action' => 'data.prix_total')); ?>",
        // Passage des données au fichier externe (ici le nom cliqué)  
        //data     : {NomEleve: "M3B"}, 
        data     : {codeProduit: productPointCode, QTY: qty},
        cache    : false,
        dataType : "json",
        error    : function(request, error) { // Info Debuggage si erreur         
                     //alert("Erreur : responseText: "+request.responseText);
                   },
        success  : function(data) {  
                     // Informe l'utilisateur que l'opération est terminé et renvoie le résultat
                     alert (data.pu);
                     $("#pu").val(data.pu);
                    // $("#pt").val(data.pu);
                   }, 
        complete    : function() { // Info Debuggage si erreur         
                     //$("#loadueclass").removeClass("fa fa-spinner fa-spin");
                   }      
     });
    //---
    return false; 
}
function calculateBillLine()
{
    //$("#loadueclass").addClass("fa fa-spinner fa-spin");
    qty = $("#pu").val();
    pu = $("#quantity").val();
    
    
    $.ajax({
        // chargement du fichier externe monfichier-ajax.php 
        url      : "application/ajax/calculateBillLine.php",
        // Passage des données au fichier externe (ici le nom cliqué)  
        //data     : {NomEleve: "M3B"}, 
        data     : {QTY: qty, PU: pu},
        cache    : false,
        dataType : "json",
        error    : function(request, error) { // Info Debuggage si erreur         
                     //alert("Erreur : responseText: "+request.responseText);
                   },
        success  : function(data) {  
                     // Informe l'utilisateur que l'opération est terminé et renvoie le résultat
                     $("#pt").val(data.prix_total);
                   }, 
        complete    : function() { // Info Debuggage si erreur         
                     //$("#loadueclass").removeClass("fa fa-spinner fa-spin");
                   }      
     });
    //---
    return false; 
}

function  openCloseAccountBox()
{
    boxId = "accountbox";
    fieldId = "date_prelevement";
    if ($("#"+boxId).is(":visible")) //--- visible
    {
        $("#"+boxId).addClass("hidden");
        $("#"+fieldId).addClass("hidden");
    }
    else //--- visible
    {
        $("#"+boxId).removeClass("hidden");
        $("#"+fieldId).removeClass("hidden");
    }
}

function  openCloseBox()
{
    boxId = "box2ecran";
    fieldId = "priceMod";
    if ($("#"+boxId).is(":visible")) //--- visible
    {
        $(".eltbox").removeClass("col-sm-3").addClass("col-sm-4");
        $("#"+boxId).addClass("hidden");
        $("#"+fieldId).addClass("hidden");
    }
    else //--- non visible
    {
        $(".eltbox").removeClass("col-sm-4").addClass("col-sm-3");
        $("#"+boxId).removeClass("hidden");
        $("#"+fieldId).removeClass("hidden");
    }
}

function number_format(number,decimals,dec_point,thousands_sep) {
    number  = number*1;//makes sure `number` is numeric value
    var str = number.toFixed(decimals?decimals:0).toString().split('.');
    var parts = [];
    for ( var i=str[0].length; i>0; i-=3 ) {
        parts.unshift(str[0].substring(Math.max(0,i-3),i));
    }
    str[0] = parts.join(thousands_sep?thousands_sep:',');
    return str.join(dec_point?dec_point:'.');
}

function replaceAll( chaine , aremplacer , par ){
    var sauvegarde = chaine;
    while( sauvegarde !== sauvegarde.replace(aremplacer,par)){
        sauvegarde = sauvegarde.replace(aremplacer,par);
    }
    return sauvegarde;
}


function Unite( nombre ){
	var unite;
	switch( nombre ){
		case 0: unite = "zéro";		break;
		case 1: unite = "un";		break;
		case 2: unite = "deux";		break;
		case 3: unite = "trois"; 	break;
		case 4: unite = "quatre"; 	break;
		case 5: unite = "cinq"; 	break;
		case 6: unite = "six"; 		break;
		case 7: unite = "sept"; 	break;
		case 8: unite = "huit"; 	break;
		case 9: unite = "neuf"; 	break;
	}//fin switch
	return unite;
}//-----------------------------------------------------------------------

function Dizaine( nombre ){
	switch( nombre ){
		case 10: dizaine = "dix"; break;
		case 11: dizaine = "onze"; break;
		case 12: dizaine = "douze"; break;
		case 13: dizaine = "treize"; break;
		case 14: dizaine = "quatorze"; break;
		case 15: dizaine = "quinze"; break;
		case 16: dizaine = "seize"; break;
		case 17: dizaine = "dix-sept"; break;
		case 18: dizaine = "dix-huit"; break;
		case 19: dizaine = "dix-neuf"; break;
		case 20: dizaine = "vingt"; break;
		case 30: dizaine = "trente"; break;
		case 40: dizaine = "quarante"; break;
		case 50: dizaine = "cinquante"; break;
		case 60: dizaine = "soixante"; break;
		case 70: dizaine = "soixante-dix"; break;
		case 80: dizaine = "quatre-vingt"; break;
		case 90: dizaine = "quatre-vingt-dix"; break;
	}//fin switch
	return dizaine;
}//-----------------------------------------------------------------------

function NumberToLetter( nombre ){
	var i, j, n, quotient, reste, nb ;
	var ch;
	var numberToLetter='';
	//__________________________________
	
	if(  nombre.toString().replace( / /gi, "" ).length > 15  )	return "dépassement de capacité";
	if(  isNaN(nombre.toString().replace( / /gi, "" ))  )		return "Nombre non valide";

	nb = parseFloat(nombre.toString().replace( / /gi, "" ));
	if(  Math.ceil(nb) !== nb  )	return  "Nombre avec virgule non géré.";
	
	n = nb.toString().length;
	switch( n ){
		 case 1: numberToLetter = Unite(nb); break;
		 case 2: if(  nb > 19  ){
					   quotient = Math.floor(nb / 10);
					   reste = nb % 10;
					   if(  nb < 71 || (nb > 79 && nb < 91)  ){
							 if(  reste == 0  ) numberToLetter = Dizaine(quotient * 10);
							 if(  reste == 1  ) numberToLetter = Dizaine(quotient * 10) + "-et-" + Unite(reste);
							 if(  reste > 1   ) numberToLetter = Dizaine(quotient * 10) + "-" + Unite(reste);
					   }else numberToLetter = Dizaine((quotient - 1) * 10) + "-" + Dizaine(10 + reste);
				 }else numberToLetter = Dizaine(nb);
				 break;
		 case 3: quotient = Math.floor(nb / 100);
				 reste = nb % 100;
				 if(  quotient == 1 && reste == 0   ) numberToLetter = "cent";
				 if(  quotient == 1 && reste != 0   ) numberToLetter = "cent" + " " + NumberToLetter(reste);
				 if(  quotient > 1 && reste == 0    ) numberToLetter = Unite(quotient) + " cents";
				 if(  quotient > 1 && reste != 0    ) numberToLetter = Unite(quotient) + " cent " + NumberToLetter(reste);
				 break;
		 case 4 :  quotient = Math.floor(nb / 1000);
					  reste = nb - quotient * 1000;
					  if(  quotient == 1 && reste == 0   ) numberToLetter = "mille";
					  if(  quotient == 1 && reste != 0   ) numberToLetter = "mille" + " " + NumberToLetter(reste);
					  if(  quotient > 1 && reste == 0    ) numberToLetter = NumberToLetter(quotient) + " mille";
					  if(  quotient > 1 && reste != 0    ) numberToLetter = NumberToLetter(quotient) + " mille " + NumberToLetter(reste);
					  break;
		 case 5 :  quotient = Math.floor(nb / 1000);
					  reste = nb - quotient * 1000;
					  if(  quotient == 1 && reste == 0   ) numberToLetter = "mille";
					  if(  quotient == 1 && reste != 0   ) numberToLetter = "mille" + " " + NumberToLetter(reste);
					  if(  quotient > 1 && reste == 0    ) numberToLetter = NumberToLetter(quotient) + " mille";
					  if(  quotient > 1 && reste != 0    ) numberToLetter = NumberToLetter(quotient) + " mille " + NumberToLetter(reste);
					  break;
		 case 6 :  quotient = Math.floor(nb / 1000);
					  reste = nb - quotient * 1000;
					  if(  quotient == 1 && reste == 0   ) numberToLetter = "mille";
					  if(  quotient == 1 && reste != 0   ) numberToLetter = "mille" + " " + NumberToLetter(reste);
					  if(  quotient > 1 && reste == 0    ) numberToLetter = NumberToLetter(quotient) + " mille";
					  if(  quotient > 1 && reste != 0    ) numberToLetter = NumberToLetter(quotient) + " mille " + NumberToLetter(reste);
					  break;
		 case 7: quotient = Math.floor(nb / 1000000);
					  reste = nb % 1000000;
					  if(  quotient == 1 && reste == 0  ) numberToLetter = "un million";
					  if(  quotient == 1 && reste != 0  ) numberToLetter = "un million" + " " + NumberToLetter(reste);
					  if(  quotient > 1 && reste == 0   ) numberToLetter = NumberToLetter(quotient) + " millions";
					  if(  quotient > 1 && reste != 0   ) numberToLetter = NumberToLetter(quotient) + " millions " + NumberToLetter(reste);
					  break;  
		 case 8: quotient = Math.floor(nb / 1000000);
					  reste = nb % 1000000;
					  if(  quotient == 1 && reste == 0  ) numberToLetter = "un million";
					  if(  quotient == 1 && reste != 0  ) numberToLetter = "un million" + " " + NumberToLetter(reste);
					  if(  quotient > 1 && reste == 0   ) numberToLetter = NumberToLetter(quotient) + " millions";
					  if(  quotient > 1 && reste != 0   ) numberToLetter = NumberToLetter(quotient) + " millions " + NumberToLetter(reste);
					  break;  
		 case 9: quotient = Math.floor(nb / 1000000);
					  reste = nb % 1000000;
					  if(  quotient == 1 && reste == 0  ) numberToLetter = "un million";
					  if(  quotient == 1 && reste != 0  ) numberToLetter = "un million" + " " + NumberToLetter(reste);
					  if(  quotient > 1 && reste == 0   ) numberToLetter = NumberToLetter(quotient) + " millions";
					  if(  quotient > 1 && reste != 0   ) numberToLetter = NumberToLetter(quotient) + " millions " + NumberToLetter(reste);
					  break;  
		 case 10: quotient = Math.floor(nb / 1000000000);
						reste = nb - quotient * 1000000000;
						if(  quotient == 1 && reste == 0  ) numberToLetter = "un milliard";
						if(  quotient == 1 && reste != 0  ) numberToLetter = "un milliard" + " " + NumberToLetter(reste);
						if(  quotient > 1 && reste == 0   ) numberToLetter = NumberToLetter(quotient) + " milliards";
						if(  quotient > 1 && reste != 0   ) numberToLetter = NumberToLetter(quotient) + " milliards " + NumberToLetter(reste);
					    break;	
		 case 11: quotient = Math.floor(nb / 1000000000);
						reste = nb - quotient * 1000000000;
						if(  quotient == 1 && reste == 0  ) numberToLetter = "un milliard";
						if(  quotient == 1 && reste != 0  ) numberToLetter = "un milliard" + " " + NumberToLetter(reste);
						if(  quotient > 1 && reste == 0   ) numberToLetter = NumberToLetter(quotient) + " milliards";
						if(  quotient > 1 && reste != 0   ) numberToLetter = NumberToLetter(quotient) + " milliards " + NumberToLetter(reste);
					    break;	
		 case 12: quotient = Math.floor(nb / 1000000000);
						reste = nb - quotient * 1000000000;
						if(  quotient == 1 && reste == 0  ) numberToLetter = "un milliard";
						if(  quotient == 1 && reste != 0  ) numberToLetter = "un milliard" + " " + NumberToLetter(reste);
						if(  quotient > 1 && reste == 0   ) numberToLetter = NumberToLetter(quotient) + " milliards";
						if(  quotient > 1 && reste != 0   ) numberToLetter = NumberToLetter(quotient) + " milliards " + NumberToLetter(reste);
					    break;	
		 case 13: quotient = Math.floor(nb / 1000000000000);
						reste = nb - quotient * 1000000000000;
						if(  quotient == 1 && reste == 0  ) numberToLetter = "un billion";
						if(  quotient == 1 && reste != 0  ) numberToLetter = "un billion" + " " + NumberToLetter(reste);
						if(  quotient > 1 && reste == 0   ) numberToLetter = NumberToLetter(quotient) + " billions";
						if(  quotient > 1 && reste != 0   ) numberToLetter = NumberToLetter(quotient) + " billions " + NumberToLetter(reste);
					    break; 	
		 case 14: quotient = Math.floor(nb / 1000000000000);
						reste = nb - quotient * 1000000000000;
						if(  quotient == 1 && reste == 0  ) numberToLetter = "un billion";
						if(  quotient == 1 && reste != 0  ) numberToLetter = "un billion" + " " + NumberToLetter(reste);
						if(  quotient > 1 && reste == 0   ) numberToLetter = NumberToLetter(quotient) + " billions";
						if(  quotient > 1 && reste != 0   ) numberToLetter = NumberToLetter(quotient) + " billions " + NumberToLetter(reste);
					    break; 	
		 case 15: quotient = Math.floor(nb / 1000000000000);
						reste = nb - quotient * 1000000000000;
						if(  quotient == 1 && reste == 0  ) numberToLetter = "un billion";
						if(  quotient == 1 && reste != 0  ) numberToLetter = "un billion" + " " + NumberToLetter(reste);
						if(  quotient > 1 && reste == 0   ) numberToLetter = NumberToLetter(quotient) + " billions";
						if(  quotient > 1 && reste != 0   ) numberToLetter = NumberToLetter(quotient) + " billions " + NumberToLetter(reste);
					    break; 	
	 }//fin switch
	 /*respect de l'accord de quatre-vingt*/
	 if(  numberToLetter.substr(numberToLetter.length-"quatre-vingt".length,"quatre-vingt".length) == "quatre-vingt"  ) numberToLetter = numberToLetter + "s";
	 
	 return numberToLetter;
}//-----------------------------------------------------------------------
