<?php

/*
 * Model's functions of Menu Entity
 */

/**
 * @author Messanga Landry <messangalandry@gmail.com>
 */
include APPLICATION_PATH . '/Models/Droit.php';

class DroitDAO {
    //put your code here
    
    function DroitDAO(){
        $registry = Zend_Registry::getInstance();
        $this->_em = $registry->entitymanager;
    }
    
    /**
     * 
     * @param Application\Models\Droit $droit
     */
    public function enregistrer($droit){
        $this->_em->persist($droit);
        $this->_em->flush();
    }
     public function getDroitProfil($idProfil){//les lignes profils de $idProfils
        $droits = $this->_em->getRepository('\Application\Models\droit')->findBy(array("idprofil" => (int)$idProfil));
        return $droits;
    }
    /**
     * 
     * @param Application\Models\Droit $droit
     */
    public function supprimer($droit){
        $this->_em->remove($droit);
        $this->_em->flush();
    }
    /**
     * 
     * @param Application\Models\Droit $droit
     */
    public function editer($droit){
        $this->_em->merge($droit);
        $this->_em->flush();
    }
    
    /**
     * 
     * @param integer $id
     * @return Application\Models\Droit
     */
    public function getDroit($id){
        $droit = $this->_em->getRepository('\Application\Models\Droit')->find((int)$id);
        return $droit;
    }
     /**
     * 
     * @param integer $id
     * @return Array Application\Models\Droit
     */
    public function getDroitByProfil($id){//les lignes profils de $idProfils
        $droits = $this->_em->getRepository('\Application\Models\Droit')->findBy(array("idprofil" => (int)$id));
        return $droits;
    }
    public function droitMenu($idProfil, $idMenu){ //dit si le profil a droit au menu
        $droit = $this->_em->getRepository('\Application\Models\Droit')
                ->findBy(array('idmenu' => (int)$idMenu,'idprofil' =>(int)$idProfil,"statut"=>1));
        if(is_array($droit) && !empty($droit) ) return true;   
        else return false;
    }
    /**
     * 
     * @param integer $id
     * @return Array Application\Models\Droit
     */
    public function obtenirProfil($idProfil, $idMenu){
        $droit = $this->_em->getRepository('\Application\Models\Droit')->findBy((int)$idProfil,(int)$idMenu);
        return $droit;
    }
    
}