<?php

/*
 * Model's functions of Fichesms Entity
 */

/**
 * @author Messanga Landry <messangalandry@gmail.com>
 */

include APPLICATION_PATH . '/Models/Fichesms.php';

class FicheSMSDAO {
    //put your code here
    public $_em;
    function FicheSMSDAO(){
        $registry = Zend_Registry::getInstance();
        $this->_em = $registry->entitymanager;
    }
    
    /**
     * 
     * @param Application\Models\Fichesms $fiche
     */
    public function enregistrer($fiche){
        $this->_em->persist($fiche);
        $this->_em->flush();
        
    }
    
    /**
     * 
     * @param Application\Models\Fichesms $fiche
     */
    public function editer($fiche){
        $this->_em->merge($fiche);
        $this->_em->flush();
    }
    
    /**
     * 
     * @param Application\Models\Fichesms $fiche
     */
    public function disable($fiche){
        $this->_em->remove($fiche);
        $this->_em->flush();
    }
    
    /**
     * 
     * 
     * @return Application\Models\Fichesms $fiche
     */
    public function getFiche($semaine,$site){
        $fiche = $this->_em->getRepository('\Application\Models\Fichesms')->findOneBy(array('semaineepidemio'=>$semaine,"formsanitaire"=>$site));
        return $fiche;
    }
    
   
}
