<?php

namespace Application\Models;

use Doctrine\ORM\Mapping as ORM;

/**
 * Menu
 *
 * @ORM\Table(name="menu")
 * @ORM\Entity
 */
class Menu
{
    /**
     * @var integer
     *
     * @ORM\Column(name="IDMENU", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $idmenu;

    /**
     * @var string
     *
     * @ORM\Column(name="NOM", type="string", length=255, nullable=true)
     */
    private $nom;

    /**
     * @var string
     *
     * @ORM\Column(name="ACTION", type="string", length=255, nullable=true)
     */
    private $action;

    /**
     * @var string
     *
     * @ORM\Column(name="CONTROLLER", type="string", length=255, nullable=true)
     */
    private $controller;

    /**
     * @var integer
     *
     * @ORM\Column(name="ORDREAPPARITION", type="smallint", nullable=true)
     */
    private $ordreapparition;

    /**
     * @var string
     *
     * @ORM\Column(name="ICON", type="string", length=255, nullable=true)
     */
    private $icon;

    /**
     * @var integer
     *
     * @ORM\Column(name="STATUT", type="smallint", nullable=true)
     */
    private $statut;

    /**
     * @var integer
     *
     * @ORM\Column(name="IDPARENT", type="bigint", nullable=true)
     */
    private $idparent;



    /**
     * Get idmenu
     *
     * @return integer 
     */
    public function getIdmenu()
    {
        return $this->idmenu;
    }

    /**
     * Set nom
     *
     * @param string $nom
     * @return Menu
     */
    public function setNom($nom)
    {
        $this->nom = $nom;
    
        return $this;
    }

    /**
     * Get nom
     *
     * @return string 
     */
    public function getNom()
    {
        return $this->nom;
    }

    /**
     * Set action
     *
     * @param string $action
     * @return Menu
     */
    public function setAction($action)
    {
        $this->action = $action;
    
        return $this;
    }

    /**
     * Get action
     *
     * @return string 
     */
    public function getAction()
    {
        return $this->action;
    }

    /**
     * Set controller
     *
     * @param string $controller
     * @return Menu
     */
    public function setController($controller)
    {
        $this->controller = $controller;
    
        return $this;
    }

    /**
     * Get controller
     *
     * @return string 
     */
    public function getController()
    {
        return $this->controller;
    }

    /**
     * Set ordreapparition
     *
     * @param integer $ordreapparition
     * @return Menu
     */
    public function setOrdreapparition($ordreapparition)
    {
        $this->ordreapparition = $ordreapparition;
    
        return $this;
    }

    /**
     * Get ordreapparition
     *
     * @return integer 
     */
    public function getOrdreapparition()
    {
        return $this->ordreapparition;
    }

    /**
     * Set icon
     *
     * @param string $icon
     * @return Menu
     */
    public function setIcon($icon)
    {
        $this->icon = $icon;
    
        return $this;
    }

    /**
     * Get icon
     *
     * @return string 
     */
    public function getIcon()
    {
        return $this->icon;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     * @return Menu
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;
    
        return $this;
    }

    /**
     * Get statut
     *
     * @return integer 
     */
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Set idparent
     *
     * @param integer $idparent
     * @return Menu
     */
    public function setIdparent($idparent)
    {
        $this->idparent = $idparent;
    
        return $this;
    }

    /**
     * Get idparent
     *
     * @return integer 
     */
    public function getIdparent()
    {
        return $this->idparent;
    }
}