<?php

namespace Application\Models;

use Doctrine\ORM\Mapping as ORM;

/**
 * Utilisateur
 *
 * @ORM\Table(name="utilisateur")
 * @ORM\Entity
 */
class Utilisateur
{
    /**
     * @var integer
     *
     * @ORM\Column(name="IDUTILISATEUR", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $idutilisateur;

    /**
     * @var string
     *
     * @ORM\Column(name="LOGIN", type="string", length=255, nullable=true)
     */
    private $login;

    /**
     * @var string
     *
     * @ORM\Column(name="PASSWORD", type="text", nullable=true)
     */
    private $password;

    /**
     * @var integer
     *
     * @ORM\Column(name="STATUT", type="smallint", nullable=true)
     */
    private $statut;

    /**
     * @var \Application\Models\Personne
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Personne")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="IDPERSONNE", referencedColumnName="IDPERSONNE")
     * })
     */
    private $idpersonne;

    /**
     * @var \Application\Models\Profil
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Profil")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="IDPROFIL", referencedColumnName="IDPROFIL")
     * })
     */
    private $idprofil;



    /**
     * Get idutilisateur
     *
     * @return integer 
     */
    public function getIdutilisateur()
    {
        return $this->idutilisateur;
    }

    /**
     * Set login
     *
     * @param string $login
     * @return Utilisateur
     */
    public function setLogin($login)
    {
        $this->login = $login;
    
        return $this;
    }

    /**
     * Get login
     *
     * @return string 
     */
    public function getLogin()
    {
        return $this->login;
    }

    /**
     * Set password
     *
     * @param string $password
     * @return Utilisateur
     */
    public function setPassword($password)
    {
        $this->password = $password;
    
        return $this;
    }

    /**
     * Get password
     *
     * @return string 
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     * @return Utilisateur
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;
    
        return $this;
    }

    /**
     * Get statut
     *
     * @return integer 
     */
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Set idpersonne
     *
     * @param \Application\Models\Personne $idpersonne
     * @return Utilisateur
     */
    public function setIdpersonne(\Application\Models\Personne $idpersonne = null)
    {
        $this->idpersonne = $idpersonne;
    
        return $this;
    }

    /**
     * Get idpersonne
     *
     * @return \Application\Models\Personne 
     */
    public function getIdpersonne()
    {
        return $this->idpersonne;
    }

    /**
     * Set idprofil
     *
     * @param \Application\Models\Profil $idprofil
     * @return Utilisateur
     */
    public function setIdprofil(\Application\Models\Profil $idprofil = null)
    {
        $this->idprofil = $idprofil;
    
        return $this;
    }

    /**
     * Get idprofil
     *
     * @return \Application\Models\Profil 
     */
    public function getIdprofil()
    {
        return $this->idprofil;
    }
}