<?php

include APPLICATION_PATH . '/DAO/UtilisateurDAO.php';
include APPLICATION_PATH . '/DAO/DroitDAO.php';
include APPLICATION_PATH . '/DAO/ProfilDAO.php';
include APPLICATION_PATH . '/DAO/MenuDAO.php';
include APPLICATION_PATH . '/DAO/LogDAO.php';
include APPLICATION_PATH . '/DAO/PersonneDAO.php';
include PUBLIC_PATH.'/Fonctions/Fonction.php';

class ProfilController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        session_start();
        if ( isset($_SESSION["idUtilisateur"])){
            $_SESSION["derniereAction"] = new \DateTime();
            $utilisateurDao = new UtilisateurDAO();
            $this->user = $utilisateurDao->getUtilisateurById((int)$_SESSION["idUtilisateur"]);
        }else{
            $this->_helper->redirector('index' , 'Index');
        }
    }

    public function indexAction()
    {
     $erromsg = "";

        try {
            $obj = new ProfilDAO();
            $this->view->listeprofils = $obj->lister();
			
        } catch (Exception $e) {
            $errormsg = "Echec de chargement des données";
			$this->view->profils="";
        }
    }

    public function enregistrerAction()
    {
       
        if (!empty($_POST)) {
            $nom = $_POST["name"];
            
            //exit();
            $error = 0;
            $idpro = 0;
            $errormsg="";
             $profilDao = new ProfilDAO();
            // Enregistrement dans la table Profil
             if($profilDao->existProfilName($nom)==true){
                    $errormsg.="Le profil:".$nom." existe déjà!";
                     $rep = array('msg' => $error, 'msg1' => $errormsg);
                     echo json_encode($rep);
                        exit();
                }
           
           try {
              
                $profilDao->_em->beginTransaction();
            $profil = new \Application\Models\Profil();
               
                // ici on fait les enregistrements......
                $profil->setNom($nom);
                $profil->setStatut(1);
                $profilDao->enregistrer($profil);
                
                $droitDao = new DroitDAO();
                $menuDao = new MenuDAO();
                
                foreach ($_POST as $index=>$unElmt)
                {
                    $tabElt = explode("_", $index); 
                    if(count($tabElt)>0 && $tabElt[0]=='checkbox')
                    {
                        $idmenu=$tabElt[1];
                        $leMenu = $menuDao->obtenirMenu((int)$idmenu);
                        
                        $droit= new \Application\Models\Droit();
                        $droit->setIdprofil($profil);
                        $droit->setIdmenu($leMenu);
                        $droit->setStatut(1);
                        //enregistrement
                        $droitDao->enregistrer($droit);
                    }
                } 
                $profilDao->_em->commit();
        } catch (Exception $ex) {
            $profilDao->_em->rollBack();
            $error = 1;
                //$this->view->errormsg=$e->getMessage();
                $errormsg = $ex->getMessage(); //"Echec d'enregistrement";
                //var_dump($e->getMessage());exit;
            
        }
            if ($error == 1) {
                $rep = array('msg' => $error, 'msg1' => $errormsg);
            } else {
                try{
                    
                    $f = new Fonction();
                    $descr = "Enregistrement du profil No ".$profil->getIdProfil()." nom ".$nom;
                     
                    $descr .= " par l'utilisateur ".utf8_encode($this->user->getIdpersonne()->getNom())." ".utf8_encode($this->user->getIdpersonne()->getPrenom())."";
                   
                    $user = $this->user;
                    if($f->EnregistrerLog($descr, $user)) ;
                    else {
                    }
                }  
                catch (Exception $exc){
                    
                }
                $rep = array('msg' => $error, 'msg1' => "enregistrement effectué avec succes");
            }
            echo json_encode($rep);
            //echo json_encode($list);
           exit();
        } else {
            $menuDao = new MenuDAO();
            $this->view->menus = $menuDao->listerMenuParents();
        }

    }
    public function editerAction()
    {
        $menuDao = new MenuDAO();
        $droitDao = new DroitDAO();
        $profilDao = new ProfilDAO();
        
        if ($this->getRequest()->getMethod() == 'POST' && !empty($_POST)) {
            $nom = $_POST["name"];
            $idProfil=$_POST["idProfil"];
            
            $profil = $profilDao->getProfil($idProfil);
            //exit();
            $error = 0;
            $idpro = 0;
            // MAJ dans la table Profil
            try {
                // ici on fait les mis à jour......
                $profil->setNom($nom);
                $profil->setStatut(1);
                $profilDao->editer($profil);
                $droits=$droitDao->getDroitProfil((int)$idProfil);
                //var_dump($lignes); die;
                if(is_array($droits)) foreach ($droits as $unDroit) $droitDao->supprimer($unDroit);
                 foreach ($_POST as $index=>$unElmt)
                    {
                        $tabElt = explode("_", $index); 
                        if(count($tabElt)>0 && $tabElt[0]=='checkbox')
                        {
                            $idmenu=$tabElt[1];
                            $leMenu = $menuDao->obtenirMenu($idmenu);
                            if($droitDao->droitMenu($profil->getIdprofil(), $leMenu->getIdmenu())==false){
                                 $droit = new \Application\Models\Droit();
                                 $droit->setIdmenu($leMenu);
                                 $droit->setIdprofil($profil);
                                 $droit->setStatut(1);
                                  //enregistrement
                            $droitDao->enregistrer($droit);
                            }
                           
                           
                           
                        }
                    } 
            } catch (Exception $e) {
                
                $error = 1;
                //$this->view->errormsg=$e->getMessage();
                $errormsg = $e->getMessage();
                //var_dump($e->getMessage());exit;
            }
                
//            } catch (Exception $e) {
//                $error = 1;
//                //$this->view->errormsg=$e->getMessage();
//                $errormsg = $e->getMessage(); //"Echec d'enregistrement";
//                //var_dump($e->getMessage());exit;
//            }

            if ($error == 1) {
                $rep = array('msg' => $error, 'msg1' => $errormsg);
            } else {
                try{
                    
                    $f = new Fonction();
                    $descr = "Edition/modification du profil No ".$idProfil." nom ".$nom;
                     
                    $descr .= " par l'utilisateur ".utf8_encode($this->user->getIdpersonne()->getNom())." ".utf8_encode($this->user->getIdpersonne()->getPrenom())."";
                   
                    $user = $this->user;
                    if($f->EnregistrerLog($descr, $user)) ;
                    else {
                    }
                }  
                catch (Exception $exc){
                    
                }
                $rep = array('msg' => $error, 'msg1' => "enregistrement effectué avec succes");
            }
            echo json_encode($rep);
            //echo json_encode($list);
            die;
        }
        else{
            $id = $this->getRequest()->getParam('id');
            $leProfil = $profilDao->getProfil($id);
            $this->view->menus = $menuDao->listerMenuParents();
           
            $this->view->profil = $leProfil;
        }
        
        
    }
    
    public function supprimerAction()
    {
        if (!is_null($this->getRequest()->getParam('id'))) {

            $id = $this->getRequest()->getParam('id');
            
            try {
                $profilDao = new ProfilDAO();
                $profil = $profilDao->getProfil($id);
                if (empty($profil)) {
                    $rep = array('msg' => "Impossible de trouver l'utilisateur");
                } else {
                    try {
                        $profil->setStatut(0);
                        $profilDao->editer($profil);
                        
                        $rep = array('msg' => "Succes");
                        
                        try{
                    
                            $f = new Fonction();
                            $descr = "Suppression du profil No ".$id;

                             $descr .= " par l'utilisateur ".utf8_encode($this->user->getIdpersonne()->getNom())." ".utf8_encode($this->user->getIdpersonne()->getPrenom())."";

                            $user = $this->user;
                            if($f->EnregistrerLog($descr, $user)) ;
                            else {
                            }
                        }  
                        catch (Exception $exc){

                        }
                        
                    } catch (Exception $ex) {
                        $rep = array('msg' => "Echec de suppression");
                        echo $ex->getMessage();
                    }
                }
            } catch (Exception $ex) {
                $rep = array('msg' => "Echec de suppression");
                echo $ex->getMessage();
            }
        } else {
            $rep = array('msg' => "Aucun élément à supprimer");
        }
        echo json_encode($rep);
        die;
    }
       public function findAction()
    {
        try{
           $nom = $_POST["nom"];
           $profilDao = new ProfilDAO();
           $liste= $profilDao->chercherProfilParNom($nom);
           $resultat = array();
           foreach ( $liste as $profil ){
               $resultat[]=["id"=>$profil->getIdprofil(),"value"=>$profil->getNom()];
              
           }
           echo json_encode(array('data'=>$resultat,'nb'=>count($resultat)));
        } catch (Exception $ex) {
           echo json_encode(array("type" => "error"));
        }
        
        exit();
        
        
    }

}

