<?php

class Bootstrap extends Zend_Application_Bootstrap_Bootstrap
{
    /**
     * generate registry
     * @return Zend_Registry
     */
    protected function _initRegistry(){
        $registry = Zend_Registry::getInstance();
        return $registry;
    }
 
    /**
     * Register namespace Default_
     * @return Zend_Application_Module_Autoloader
     */
    protected function _initAutoload()
    {
        $autoloader = new Zend_Application_Module_Autoloader(array(
            'namespace' => 'Default_',
            'basePath'  => dirname(__FILE__),
        ));
        return $autoloader;
    }
 
    /**
     * Initialize Doctrine
     * @return Doctrine_Manager
     */
    public function _initDoctrine() {
        // include and register Doctrine's class loader
        require_once('Doctrine/Common/ClassLoader.php');
        $classLoader = new \Doctrine\Common\ClassLoader(
            'Doctrine',
            APPLICATION_PATH . '/../library/'
        );
        $classLoader->register();
 
        // create the Doctrine configuration
        $config = new \Doctrine\ORM\Configuration();
 
        // setting the cache ( to ArrayCache. Take a look at
        // the Doctrine manual for different options ! )
        $cache = new \Doctrine\Common\Cache\ArrayCache;
        $config->setMetadataCacheImpl($cache);
        $config->setQueryCacheImpl($cache);
 
        // choosing the driver for our database schema
        // we'll use annotations
        $driver = $config->newDefaultAnnotationDriver(
            APPLICATION_PATH . '/Models',false
        ); 
        $config->setMetadataDriverImpl($driver);
 
        // set the proxy dir and set some options
        $config->setProxyDir(APPLICATION_PATH . '/Models/Proxies');
        $config->setAutoGenerateProxyClasses(true);
        $config->setProxyNamespace('App\Proxies');
 
        // now create the entity manager and use the connection
        // settings we defined in our application.ini
        $connectionSettings = $this->getOption('doctrine');
        $conn =array(	
			'driver'    => 'pdo_mysql',
            'user'      => 'root',
            'password'  => 'fF6BvJ3cjvLQfURt',
            'dbname'    => 'surveillance',
            'host'      => 'localhost'
        );
         $entityManager = \Doctrine\ORM\EntityManager::create($conn, $config);
 
        // push the entity manager into our registry for later use
        $registry = Zend_Registry::getInstance();
        $registry->entitymanager = $entityManager;
 
        return $entityManager;
    }
 
}

