<?php

/*
 * Model's functions of Parametre Entity
 */

/**
 * @author Messanga Landry <messangalandry@gmail.com>
 */

include APPLICATION_PATH . '/Models/Parametre.php';

class ParametreDAO {
    //put your code here
    
    function ParametreDAO(){
        $registry = Zend_Registry::getInstance();
        $this->_em = $registry->entitymanager;
    }
    
    /**
     * 
     * @param Application\Models\Parametre $parametre
     */
    public function enregistrer($parametre){
        $this->_em->persist($parametre);
        $this->_em->flush();
        
    }
    
    /**
     * 
     * @param Application\Models\Parametre $parametre
     */
    public function editer($parametre){
        $this->_em->merge($parametre);
        $this->_em->flush();
    }
    
    /**
     * 
     * @param integer $id
     * @return Application\Models\Parametre
     */
    public function getParametre($id){
        $parametre = $this->_em->getRepository('\Application\Models\Parametre')->find($id);
        return $parametre;
    }
    
    /**
     * 
     * @return Array of \Application\Models\Parametre
     */
    public function listerParametre(){
        $listeParametre = $this->_em->getRepository("\Application\Models\Parametre")->findAll();
        return $listeParametre;
    }
    
    /**
     * 
     * @param string $nom
     * @return \Application\Models\Parametre
     */
    public function getParametreParNom($nom){
        $parametre = $this->_em->getRepository("\Application\Models\Parametre")->findOneBy(array("nom" => $nom));
        
        return $parametre;
    }
   
}
