<?php

namespace Application\Models;

use Doctrine\ORM\Mapping as ORM;

/**
 * Parametre
 *
 * @ORM\Table(name="parametre")
 * @ORM\Entity
 */
class Parametre
{
    /**
     * @var integer
     *
     * @ORM\Column(name="ID_PARAMETRE", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $idParametre;

    /**
     * @var string
     *
     * @ORM\Column(name="NOM", type="string", length=300, nullable=true)
     */
    private $nom;

    /**
     * @var string
     *
     * @ORM\Column(name="VALEUR", type="text", nullable=true)
     */
    private $valeur;



    /**
     * Get idParametre
     *
     * @return integer 
     */
    public function getIdParametre()
    {
        return $this->idParametre;
    }

    /**
     * Set nom
     *
     * @param string $nom
     * @return Parametre
     */
    public function setNom($nom)
    {
        $this->nom = $nom;
    
        return $this;
    }

    /**
     * Get nom
     *
     * @return string 
     */
    public function getNom()
    {
        return $this->nom;
    }

    /**
     * Set valeur
     *
     * @param string $valeur
     * @return Parametre
     */
    public function setValeur($valeur)
    {
        $this->valeur = $valeur;
    
        return $this;
    }

    /**
     * Get valeur
     *
     * @return string 
     */
    public function getValeur()
    {
        return $this->valeur;
    }
}