<?php

namespace Application\Models;

use Doctrine\ORM\Mapping as ORM;

/**
 * Personne
 *
 * @ORM\Table(name="personne")
 * @ORM\Entity
 */
class Personne
{
    /**
     * @var integer
     *
     * @ORM\Column(name="IDPERSONNE", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $idpersonne;

    /**
     * @var string
     *
     * @ORM\Column(name="NOM", type="string", length=255, nullable=true)
     */
    private $nom;

    /**
     * @var string
     *
     * @ORM\Column(name="PRENOM", type="string", length=255, nullable=true)
     */
    private $prenom;

    /**
     * @var string
     *
     * @ORM\Column(name="SEXE", type="string", length=1, nullable=true)
     */
    private $sexe;

    /**
     * @var string
     *
     * @ORM\Column(name="TELEPHONE", type="string", length=20, nullable=true)
     */
    private $telephone;

    /**
     * @var string
     *
     * @ORM\Column(name="NUMCARTE", type="string", length=50, nullable=true)
     */
    private $numcarte;

    /**
     * @var string
     *
     * @ORM\Column(name="VILLE", type="string", length=50, nullable=true)
     */
    private $ville;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="DATENAISSANCE", type="datetime", nullable=true)
     */
    private $datenaissance;

    /**
     * @var string
     *
     * @ORM\Column(name="NOMJEUNEFILLE", type="string", length=255, nullable=true)
     */
    private $nomjeunefille;

    /**
     * @var string
     *
     * @ORM\Column(name="NATIONALITE", type="string", length=255, nullable=true)
     */
    private $nationalite;

    /**
     * @var string
     *
     * @ORM\Column(name="LIEUNAISSANCE", type="string", length=255, nullable=true)
     */
    private $lieunaissance;

    /**
     * @var string
     *
     * @ORM\Column(name="PAYSRESIDENCE", type="string", length=255, nullable=true)
     */
    private $paysresidence;

    /**
     * @var string
     *
     * @ORM\Column(name="PROFESSION", type="string", length=255, nullable=true)
     */
    private $profession;

    /**
     * @var string
     *
     * @ORM\Column(name="VENANTDE", type="string", length=255, nullable=true)
     */
    private $venantde;

    /**
     * @var string
     *
     * @ORM\Column(name="SERENDANT", type="string", length=255, nullable=true)
     */
    private $serendant;

    /**
     * @var integer
     *
     * @ORM\Column(name="STATUT", type="smallint", nullable=true)
     */
    private $statut;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="DATEDELIVRANCECNI", type="datetime", nullable=true)
     */
    private $datedelivrancecni;

    /**
     * @var string
     *
     * @ORM\Column(name="LIEUDELIVRANCECNI", type="string", length=255, nullable=true)
     */
    private $lieudelivrancecni;

    /**
     * @var string
     *
     * @ORM\Column(name="MODETRANSPORT", type="string", length=255, nullable=true)
     */
    private $modetransport;

    /**
     * @var string
     *
     * @ORM\Column(name="IMMATRICULATION", type="string", length=255, nullable=true)
     */
    private $immatriculation;



    /**
     * Get idpersonne
     *
     * @return integer 
     */
    public function getIdpersonne()
    {
        return $this->idpersonne;
    }

    /**
     * Set nom
     *
     * @param string $nom
     * @return Personne
     */
    public function setNom($nom)
    {
        $this->nom = $nom;
    
        return $this;
    }

    /**
     * Get nom
     *
     * @return string 
     */
    public function getNom()
    {
        return $this->nom;
    }

    /**
     * Set prenom
     *
     * @param string $prenom
     * @return Personne
     */
    public function setPrenom($prenom)
    {
        $this->prenom = $prenom;
    
        return $this;
    }

    /**
     * Get prenom
     *
     * @return string 
     */
    public function getPrenom()
    {
        return $this->prenom;
    }

    /**
     * Set sexe
     *
     * @param string $sexe
     * @return Personne
     */
    public function setSexe($sexe)
    {
        $this->sexe = $sexe;
    
        return $this;
    }

    /**
     * Get sexe
     *
     * @return string 
     */
    public function getSexe()
    {
        return $this->sexe;
    }

    /**
     * Set telephone
     *
     * @param string $telephone
     * @return Personne
     */
    public function setTelephone($telephone)
    {
        $this->telephone = $telephone;
    
        return $this;
    }

    /**
     * Get telephone
     *
     * @return string 
     */
    public function getTelephone()
    {
        return $this->telephone;
    }

    /**
     * Set numcarte
     *
     * @param string $numcarte
     * @return Personne
     */
    public function setNumcarte($numcarte)
    {
        $this->numcarte = $numcarte;
    
        return $this;
    }

    /**
     * Get numcarte
     *
     * @return string 
     */
    public function getNumcarte()
    {
        return $this->numcarte;
    }

    /**
     * Set ville
     *
     * @param string $ville
     * @return Personne
     */
    public function setVille($ville)
    {
        $this->ville = $ville;
    
        return $this;
    }

    /**
     * Get ville
     *
     * @return string 
     */
    public function getVille()
    {
        return $this->ville;
    }

    /**
     * Set datenaissance
     *
     * @param \DateTime $datenaissance
     * @return Personne
     */
    public function setDatenaissance($datenaissance)
    {
        $this->datenaissance = $datenaissance;
    
        return $this;
    }

    /**
     * Get datenaissance
     *
     * @return \DateTime 
     */
    public function getDatenaissance()
    {
        return $this->datenaissance;
    }

    /**
     * Set nomjeunefille
     *
     * @param string $nomjeunefille
     * @return Personne
     */
    public function setNomjeunefille($nomjeunefille)
    {
        $this->nomjeunefille = $nomjeunefille;
    
        return $this;
    }

    /**
     * Get nomjeunefille
     *
     * @return string 
     */
    public function getNomjeunefille()
    {
        return $this->nomjeunefille;
    }

    /**
     * Set nationalite
     *
     * @param string $nationalite
     * @return Personne
     */
    public function setNationalite($nationalite)
    {
        $this->nationalite = $nationalite;
    
        return $this;
    }

    /**
     * Get nationalite
     *
     * @return string 
     */
    public function getNationalite()
    {
        return $this->nationalite;
    }

    /**
     * Set lieunaissance
     *
     * @param string $lieunaissance
     * @return Personne
     */
    public function setLieunaissance($lieunaissance)
    {
        $this->lieunaissance = $lieunaissance;
    
        return $this;
    }

    /**
     * Get lieunaissance
     *
     * @return string 
     */
    public function getLieunaissance()
    {
        return $this->lieunaissance;
    }

    /**
     * Set paysresidence
     *
     * @param string $paysresidence
     * @return Personne
     */
    public function setPaysresidence($paysresidence)
    {
        $this->paysresidence = $paysresidence;
    
        return $this;
    }

    /**
     * Get paysresidence
     *
     * @return string 
     */
    public function getPaysresidence()
    {
        return $this->paysresidence;
    }

    /**
     * Set profession
     *
     * @param string $profession
     * @return Personne
     */
    public function setProfession($profession)
    {
        $this->profession = $profession;
    
        return $this;
    }

    /**
     * Get profession
     *
     * @return string 
     */
    public function getProfession()
    {
        return $this->profession;
    }

    /**
     * Set venantde
     *
     * @param string $venantde
     * @return Personne
     */
    public function setVenantde($venantde)
    {
        $this->venantde = $venantde;
    
        return $this;
    }

    /**
     * Get venantde
     *
     * @return string 
     */
    public function getVenantde()
    {
        return $this->venantde;
    }

    /**
     * Set serendant
     *
     * @param string $serendant
     * @return Personne
     */
    public function setSerendant($serendant)
    {
        $this->serendant = $serendant;
    
        return $this;
    }

    /**
     * Get serendant
     *
     * @return string 
     */
    public function getSerendant()
    {
        return $this->serendant;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     * @return Personne
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;
    
        return $this;
    }

    /**
     * Get statut
     *
     * @return integer 
     */
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Set datedelivrancecni
     *
     * @param \DateTime $datedelivrancecni
     * @return Personne
     */
    public function setDatedelivrancecni($datedelivrancecni)
    {
        $this->datedelivrancecni = $datedelivrancecni;
    
        return $this;
    }

    /**
     * Get datedelivrancecni
     *
     * @return \DateTime 
     */
    public function getDatedelivrancecni()
    {
        return $this->datedelivrancecni;
    }

    /**
     * Set lieudelivrancecni
     *
     * @param string $lieudelivrancecni
     * @return Personne
     */
    public function setLieudelivrancecni($lieudelivrancecni)
    {
        $this->lieudelivrancecni = $lieudelivrancecni;
    
        return $this;
    }

    /**
     * Get lieudelivrancecni
     *
     * @return string 
     */
    public function getLieudelivrancecni()
    {
        return $this->lieudelivrancecni;
    }

    /**
     * Set modetransport
     *
     * @param string $modetransport
     * @return Personne
     */
    public function setModetransport($modetransport)
    {
        $this->modetransport = $modetransport;
    
        return $this;
    }

    /**
     * Get modetransport
     *
     * @return string 
     */
    public function getModetransport()
    {
        return $this->modetransport;
    }

    /**
     * Set immatriculation
     *
     * @param string $immatriculation
     * @return Personne
     */
    public function setImmatriculation($immatriculation)
    {
        $this->immatriculation = $immatriculation;
    
        return $this;
    }

    /**
     * Get immatriculation
     *
     * @return string 
     */
    public function getImmatriculation()
    {
        return $this->immatriculation;
    }
}