<?php

namespace Application\Models;

use Doctrine\ORM\Mapping as ORM;

/**
 * Droit
 *
 * @ORM\Table(name="droit")
 * @ORM\Entity
 */
class Droit
{
    /**
     * @var integer
     *
     * @ORM\Column(name="IDDROIT", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $iddroit;

    /**
     * @var integer
     *
     * @ORM\Column(name="STATUT", type="smallint", nullable=true)
     */
    private $statut;

    /**
     * @var \Application\Models\Menu
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Menu")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="IDMENU", referencedColumnName="IDMENU")
     * })
     */
    private $idmenu;

    /**
     * @var \Application\Models\Profil
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Profil")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="IDPROFIL", referencedColumnName="IDPROFIL")
     * })
     */
    private $idprofil;



    /**
     * Get iddroit
     *
     * @return integer 
     */
    public function getIddroit()
    {
        return $this->iddroit;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     * @return Droit
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;
    
        return $this;
    }

    /**
     * Get statut
     *
     * @return integer 
     */
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Set idmenu
     *
     * @param \Application\Models\Menu $idmenu
     * @return Droit
     */
    public function setIdmenu(\Application\Models\Menu $idmenu = null)
    {
        $this->idmenu = $idmenu;
    
        return $this;
    }

    /**
     * Get idmenu
     *
     * @return \Application\Models\Menu 
     */
    public function getIdmenu()
    {
        return $this->idmenu;
    }

    /**
     * Set idprofil
     *
     * @param \Application\Models\Profil $idprofil
     * @return Droit
     */
    public function setIdprofil(\Application\Models\Profil $idprofil = null)
    {
        $this->idprofil = $idprofil;
    
        return $this;
    }

    /**
     * Get idprofil
     *
     * @return \Application\Models\Profil 
     */
    public function getIdprofil()
    {
        return $this->idprofil;
    }
}