<?php

/*
 * Model's functions of Menu Entity
 */

/**
 * @author Messanga Landry <messangalandry@gmail.com>
 */
include APPLICATION_PATH . '/Models/Authorisation.php';

class AuthorisationDAO {
    //put your code here
    public $_em;
    function AuthorisationDAO(){
        $registry = Zend_Registry::getInstance();
        $this->_em = $registry->entitymanager;
    }
    
    public function save($authorisation){
        $this->_em->persist($authorisation);
       
        $this->_em->flush();
          
        
    }
    public function delete($authorisation){
        $authorisation.setState(0);
        $this->_em->merge($authorisation);
        $this->_em->flush();
    }

    public function edit($authorisation){
        $this->_em->merge($authorisation);
        $this->_em->flush();
    }
    
    public function getAuthorisationByCode($code){
        $authorisation= $this->_em->getRepository('\Application\Models\Authorisation') ->find($code);
        return $authorisation;
    }
   
     public function getAuthorisationByLabel($label){
        
        try {
            $resultat = $this->_em->getRepository("\Application\Models\Authorisation")->createQueryBuilder("a")
                    ->Where("a.statut=1")
                    ->andWhere("a.label LIKE :label")
                    ->setParameter("label",  "%".$label . "%")
                    ->getQuery()
                    ->getResult();
            return $resultat;
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }

    }
    
    public function listAll(){
        $liste = $this->_em->getRepository('\Application\Models\Authorisation')
                ->findBy(array("state"=>1));
           return $liste;
    }
     public function listAuthParent(){ //lister tous les menus parents

        $liste = $this->_em->getRepository('\Application\Models\Authorisation')
                ->findBy(array('parent' => NULL),array('ordre' => 'ASC'));
          

           return $liste;
    }
     
    public function listerSousAuths($unAuth){ //lister tous les sous-menus du menu en paramètre
         
        $liste = $this->_em->getRepository('\Application\Models\Authorisation')
                ->findBy(array('parent' => $unAuth));
        
           return $liste;
    }

}
