<?php

/*
 * Model's functions of Consommable Entity
 */

/**
 * @author Messanga Landry <messangalandry@gmail.com>
 */

include APPLICATION_PATH . '/Models/Consommable.php';

class ConsommableDAO {
    //put your code here
    public $_em;
    function ConsommableDAO(){
        $registry = Zend_Registry::getInstance();
        $this->_em = $registry->entitymanager;
    }
    
    /**
     * 
     * @param Application\Models\Consommable $consommable
     */
    public function save($consommable){
        
        $this->_em->persist($consommable);
        $this->_em->flush();
        
    }
    
    /**
     * 
     * @param Application\Models\Consommable $consommable
     */
    public function edit($consommable){
        $this->_em->merge($consommable);
        $this->_em->flush();
    }
    //Delete un site
    public function delete($consommable) {

        $this->_em->merge($consommable);
        $this->_em->flush();
    }
    
    // /**
    //  * 
    //  * @param Application\Models\Role $fiche
    //  */
    // public function disable($fiche){
    //     $this->_em->remove($fiche);
    //     $this->_em->flush();
    // }
    
    /**
    
     * @return Application\Models\Consommable
     */
    public function listAll(){
           $liste =  $this->_em->getRepository("\Application\Models\Consommable")->findBy(array("state" => 1));
          
           return $liste;
    }
     /**
     * 
     * @param string $libelle
     * @return Application\Models\Consommable
     */
    public function getConsoById($id){
       
        $consommable = $this->_em->getRepository('\Application\Models\Consommable')->findOneBy(array("id" => $id,"state"=>1));
        return $consommable;
    }
    
    
    
    public function existSiteName($libelle){

           try{
            
            $liste = $this->_em->getRepository("\Application\Models\Consommable")->createQueryBuilder("a")
                             ->where("UPPER(a.libelle) like :libelle")
                             ->setParameter("libelle" , '%'.strtoupper($libelle) . '%')
                             ->andWhere("a.state=1")
                             //->andWhere("a.parent=:parent")
                             //->setParameter("parent" , $parent)
                             ->getQuery()
                             ->getResult();
            
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }
         
        
        if(count($liste)>0 && is_array($liste) )return true;
        else return false;
    }
      public function findByName($libelle){
        $liste = $this->_em->createQueryBuilder()
                ->select('c')
                ->from("\Application\Models\Consommable","c")
                ->where('c.state = 1')
                ->andWhere('c.libelle like :libelle ')
                ->setParameter('libelle',"%".$libelle."%")
                ->getQuery()
                ->getResult();
       
        return $liste;
    }
  

}
