<?php

/*
 * Model's functions of Emplacement Entity
 */

/**
 * @author Messanga Landry <messangalandry@gmail.com>
 */

include APPLICATION_PATH . '/Models/Emplacement.php';

class EmplacementDAO {
    //put your code here
    public $_em;
    function EmplacementDAO(){
        $registry = Zend_Registry::getInstance();
        $this->_em = $registry->entitymanager;
    }
    
    /**
     * 
     * @param Application\Models\Emplacement $emplacement
     */
    public function save($emplacement){
        
        $this->_em->persist($emplacement);
        $this->_em->flush();
        
    }
    
    /**
     * 
     * @param Application\Models\Emplacement $emplacement
     */
    public function edit($emplacement){
        $this->_em->merge($emplacement);
        $this->_em->flush();
    }
    //Delete un site
    public function delete($emplacement) {

        $this->_em->merge($emplacement);
        $this->_em->flush();
    }
    
 
    
    /**
    
     * @return Application\Models\Emplacement
     */
    public function listAll(){
           $liste =  $this->_em->getRepository("\Application\Models\Emplacement")->findBy(array("state" => 1));
          
           return $liste;
    }
     /**
     * 
     * @param string $libelle
     * @return Application\Models\Emplacement
     */
    public function getEmpById($id){
       
        $emplacement = $this->_em->getRepository('\Application\Models\Emplacement')->findOneBy(array("id" => $id,"state"=>1));
        return $emplacement;
    }
    
    
    
    public function existEmplacementName($nom){

           try{
            
            $liste = $this->_em->getRepository("\Application\Models\Emplacement")->createQueryBuilder("a")
                             ->where("UPPER(a.nom) like :nom")
                             ->setParameter("nom" , '%'.strtoupper($nom) . '%')
                             ->andWhere("a.state=1")
                             //->andWhere("a.parent=:parent")
                             //->setParameter("parent" , $parent)
                             ->getQuery()
                             ->getResult();
            
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }
         
        
        if(count($liste)>0 && is_array($liste) )return true;
        else return false;
    }
      public function findByName($nom){
        $liste = $this->_em->createQueryBuilder()
                ->select('c')
                ->from("\Application\Models\Emplacement","c")
                ->where('c.state = 1')
                ->andWhere('c.nom like :nom ')
                ->setParameter('nom',"%".$nom."%")
                ->getQuery()
                ->getResult();
       
        return $liste;
    }
  

}
