<?php

/*
 * Model's functions of EntreeConsommable Entity
 */

/**
 * @author Messanga Landry <messangalandry@gmail.com>
 */

include APPLICATION_PATH . '/Models/EntreeConsommable.php';

class EntreeConsommableDAO {
    //put your code here
    public $_em;
    function EntreeConsommableDAO(){
        $registry = Zend_Registry::getInstance();
        $this->_em = $registry->entitymanager;
    }
    
    /**
     * 
     * @param Application\Models\EntreeConsommable $entree
     */
    public function save($entree){
        
        $this->_em->persist($entree);
        $this->_em->flush();
        
    }
    
    /**
     * 
     * @param Application\Models\EntreeConsommable $entree
     */
    public function edit($entree){
        $this->_em->merge($entree);
        $this->_em->flush();
    }
    //Delete un site
    public function delete($entree) {

        $this->_em->merge($entree);
        $this->_em->flush();
    }
    
   
    
    /**
    
     * @return Application\Models\EntreeConsommable
     */
    public function listAll(){
           $liste =  $this->_em->getRepository("\Application\Models\EntreeConsommable")->findBy(array("state" => 1));
          
           return $liste;
    }
//    /**
//    
//     * @return Application\Models\EntreeConsommable
//     */
//    public function getEntreeByFourniture(Application\Models\Fourniture $fourniture){
//           $liste =  $this->_em->getRepository("\Application\Models\EntreeConsommable")->findBy(array('fourniture'=>$fourniture,"state" => 1));
//          
//           return $liste;
//    }
   
    public function getEntreeByFourniture($fourniture){
          $liste = $this->_em->createQueryBuilder()
                ->select('c')
                ->from("\Application\Models\Entreeconsommable","c")
                ->where('c.state = 1')
                ->andWhere('c.fourniture = :fourniture ')
                ->setParameter('fourniture',$fourniture)
                ->getQuery()
                ->getResult();
       
        return $liste;
    }
     
     

  

}
