<?php

/*
 * Model's functions of SortieConsommable Entity
 */

/**
 * @author Messanga Landry <messangalandry@gmail.com>
 */

include APPLICATION_PATH . '/Models/Fourniture.php';

class FournitureDAO {
    //put your code here
    public $_em;
    function FournitureDAO(){
        $registry = Zend_Registry::getInstance();
        $this->_em = $registry->entitymanager;
    }
    
    /**
     * 
     * @param Application\Models\Fourniture $fourniture
     */
    public function save($fourniture){
        
        $this->_em->persist($fourniture);
        $this->_em->flush();
        return $fourniture;
        
    }
    
    /**
     * 
     * @param Application\Models\Fourniture $fourniture
     */
    public function edit($fourniture){
        $this->_em->merge($fourniture);
        $this->_em->flush();
    }
    //Delete un site
    public function delete($fourniture) {

        $this->_em->merge($fourniture);
        $this->_em->flush();
    }
    
   
    
    /**
    
     * @return Application\Models\Fourniture
     */
    public function listAll(){
           $liste =  $this->_em->getRepository("\Application\Models\Fourniture")->findBy(array("state" => 1));
          
           return $liste;
    }
    
     /**
    
     * @return Application\Models\Fourniture
     */
    public function getFournitureById($id){
           $fourniture =  $this->_em->getRepository("\Application\Models\Fourniture")->findOneBy(array("id"=>$id,"state" => 1));
          
           return $fourniture;
    }
    
    /**
    
     * @return Application\Models\Fourniture
     */
    public function listFournitureByName($name){
          $liste = $this->_em->createQueryBuilder()
                ->select('c')
                ->from("\Application\Models\Fourniture","c")
                ->where('c.state = 1')
                ->andWhere('c.nom like :name ')
                ->setParameter('name',"%".$name."%")
                ->getQuery()
                ->getResult();
       
        return $liste;
    }
     
     

  

}
