<?php

/*
 * Model's functions of NatureEchantillon Entity
 */

/**
 * @author Messanga Landry <messangalandry@gmail.com>
 */

include APPLICATION_PATH . '/Models/NatureEchantilon.php';

class NatureEchantilonDAO {
    //put your code here
    public $_em;
    function NatureEchantilonDAO(){
        $registry = Zend_Registry::getInstance();
        $this->_em = $registry->entitymanager;
    }
    
    /**
     * 
     * @param Application\Models\NatureEchantilon $natEchan
     */
    public function save($natEchan){
        $this->_em->persist($natEchan);
        $this->_em->flush();
        
    }
    
    /**
     * 
     * @param Application\Models\NatureEchantillon $natEchan
     */
    public function edit($natEchan){
        $this->_em->merge($natEchan);
        $this->_em->flush();
    }
    //Delete un site
    public function delete($site) {

        $this->_em->merge($site);
        $this->_em->flush();
    }
    
    // /**
    //  * 
    //  * @param Application\Models\NatureEchantillon $natEchan
    //  */
    // public function disable($fiche){
    //     $this->_em->remove($fiche);
    //     $this->_em->flush();
    // }
    
    /**
    
     * @return Application\Models\NatureEchantillon
     */
    public function listAll(){
           $liste =  $this->_em->getRepository("\Application\Models\NatureEchantillon")->findBy(array("state" => 1));
          
           return $liste;
    }
     /**
     * 
     * @param string $code
     * @return Application\Models\NatureEchantillon
     */
    public function getNatureEchantillonByCode($code){
        $site = $this->_em->getRepository('\Application\Models\NatureEchantillon')->findOneBy(array("code" => $code,"state"=>1));
        return $site;
    }
    
   
      public function findByName($name){
        $liste = $this->_em->createQueryBuilder()
                ->select('c')
                ->from("\Application\Models\NatureEchantillon","c")
                ->where('c.state = 1')
                ->andWhere('c.name like :name ')
                ->setParameter('name',"%".$name."%")
                ->getQuery()
                ->getResult();
       
        return $liste;
    }
  

}
