<?php

/*
 * Model's functions of SortieConsommable Entity
 */

/**
 * @author Messanga Landry <messangalandry@gmail.com>
 */

include APPLICATION_PATH . '/Models/SortieConsommable.php';

class SortieConsommableDAO {
    //put your code here
    public $_em;
    function SortieConsommableDAO(){
        $registry = Zend_Registry::getInstance();
        $this->_em = $registry->entitymanager;
    }
    
    /**
     * 
     * @param Application\Models\SortieConsommable $sortieConso
     */
    public function save($sortieConso){
        
        $this->_em->persist($sortieConso);
        $this->_em->flush();
        
    }
    
    /**
     * 
     * @param Application\Models\SortieConsommable $sortieConso
     */
    public function edit($sortieConso){
        $this->_em->merge($sortieConso);
        $this->_em->flush();
    }
    //Delete un site
    public function delete($sortieConso) {

        $this->_em->merge($sortieConso);
        $this->_em->flush();
    }
    
   
    
    /**
    
     * @return Application\Models\SortieConsommable
     */
    public function listAll(){
           $liste =  $this->_em->getRepository("\Application\Models\SortieConsommable")->findBy(array("state" => 1));
          
           return $liste;
    }
    
    public function getItemBySortie(Application\Models\Sortie $sortie){
          $liste = $this->_em->createQueryBuilder()
                ->select('c')
                ->from("\Application\Models\SortieConsommable","c")
                ->where('c.state = 1')
                ->andWhere('c.sortie = :sortie ')
                ->setParameter('sortie',$sortie)
                ->getQuery()
                ->getResult();
       
        return $liste;
    }
     
     

  

}
