<?php

/*
 * Model's functions of Sortie Entity
 */

/**
 * @author Messanga Landry <messangalandry@gmail.com>
 */

include APPLICATION_PATH . '/Models/Sortie.php';

class SortieDAO {
    //put your code here
    public $_em;
    function SortieDAO(){
        $registry = Zend_Registry::getInstance();
        $this->_em = $registry->entitymanager;
    }
    
    /**
     * 
     * @param Application\Models\Sortie $sortie
     */
    public function save($sortie){
            
        try {
            $this->_em->persist($sortie);
            $this->_em->flush();
           
            return $sortie;
        } catch (Exception $ex) {
            var_dump($ex->getMessage());
        }
       
        
    }
    
    /**
     * 
     * @param Application\Models\Sortie $sortie
     */
    public function edit($sortie){
        $this->_em->merge($sortie);
        $this->_em->flush();
    }
    //Delete un site
    public function delete($sortie) {

        $this->_em->merge($sortie);
        $this->_em->flush();
    }
    
   
    
    /**
    
     * @return Application\Models\Sortie
     */
    public function listAll(){
           $liste =  $this->_em->getRepository("\Application\Models\Sortie")->findBy(array("state" => 1));
          
           return $liste;
    }
     /**
    
     * @return Application\Models\Sortie
     */
    public function getSortieById($id){
           $fourniture =  $this->_em->getRepository("\Application\Models\Sortie")->findOneBy(array("id"=>(int)$id,"state" => 1));
          
           return $fourniture;
    } 
    
  

}
