<?php

namespace Application\Models;

use Doctrine\ORM\Mapping as ORM;

/**
 * EntreeConsommable
 *
 * @ORM\Table(name="entreeconsommable")
 * @ORM\Entity
 */
class EntreeConsommable
{
    /**
     * @var string
     *
     * @ORM\Column(name="id", type="bigint", length=50, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    

   

    /**
     * @var integer
     *
     * @ORM\Column(name="nombre", type="bigint", length=50, nullable=true)
     */
    private $nombre;

    /**
     * @var integer
     *
     * @ORM\Column(name="STATE", type="smallint", nullable=true)
     */
    private $state;
     /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateentree", type="datetime", nullable=true)
     */
    private $dateentree;
    /**
     * @var \Application\Models\Consommable
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Consommable")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="consommable", referencedColumnName="id")
     * })
     */
    private $consommable;
    
    /**
     * @var \Application\Models\Fourniture
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Fourniture")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="fourniture", referencedColumnName="id")
     * })
     */
    private $fourniture;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nombre
     *
     * @param string $nombre
     * @return EntreeConsommable
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;
    
        return $this;
    }

    /**
     * Get nombre
     *
     * @return integer 
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * Set dateentree
     *
     * @param datetime $dateentree
     * @return EntreeConsommable
     */
    public function setDateentree($dateentree)
    {
        $this->dateentree = $dateentree;
    
        return $this;
    }

    /**
     * Get dateentree
     *
     * @return datetime 
     */
    public function getDateentree()
    {
        return $this->dateentree;
    }

    /**
     * Set consommable
     *
     * @param \Application\Models\Consommable $consommable
     * @return EntreeConsommable
     */
    public function setConsommable(\Application\Models\Consommable $consommable = null)
    {
        $this->consommable = $consommable;
    
        return $this;
    }

    /**
     * Get consommable
     *
     * @return \Application\Models\Consommable 
     */
    public function getConsommable()
    {
        return $this->consommable;
    }
    

    /**
     * Set state
     *
     * @param integer $state
     * @return Authorisation
     */
    public function setState($state)
    {
        $this->state = $state;
    
        return $this;
    }

    

    /**
     * Get state
     *
     * @return integer 
     */
    public function getState()
    {
        return $this->state;
    }

}