<?php

namespace Application\Models;

use Doctrine\ORM\Mapping as ORM;

/**
 * InformationMaladie
 *
 * @ORM\Table(name="information_maladie")
 * @ORM\Entity
 */
class InformationMaladie
{
    /**
     * @var string
     *
     * @ORM\Column(name="CODE", type="string", length=50, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $code;

    /**
     * @var string
     *
     * @ORM\Column(name="NAME", type="string", length=100, nullable=true)
     */
    private $name;

    /**
     * @var integer
     *
     * @ORM\Column(name="STATE", type="smallint", nullable=true)
     */
    private $state;

    /**
     * @var \Application\Models\TypeInformationMaladie
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\TypeInformationMaladie")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="TYPEINFORMATION", referencedColumnName="CODE")
     * })
     */
    private $typeinformation;



    /**
     * Get code
     *
     * @return string 
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return InformationMaladie
     */
    public function setName($name)
    {
        $this->name = $name;
    
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set state
     *
     * @param integer $state
     * @return InformationMaladie
     */
    public function setState($state)
    {
        $this->state = $state;
    
        return $this;
    }

    /**
     * Get state
     *
     * @return integer 
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Set typeinformation
     *
     * @param \Application\Models\TypeInformationMaladie $typeinformation
     * @return InformationMaladie
     */
    public function setTypeinformation(\Application\Models\TypeInformationMaladie $typeinformation = null)
    {
        $this->typeinformation = $typeinformation;
    
        return $this;
    }

    /**
     * Get typeinformation
     *
     * @return \Application\Models\TypeInformationMaladie 
     */
    public function getTypeinformation()
    {
        return $this->typeinformation;
    }
}