<?php

namespace Application\Models;

use Doctrine\ORM\Mapping as ORM;

/**
 * MaladieInformationmaladie
 *
 * @ORM\Table(name="maladie_informationmaladie")
 * @ORM\Entity
 */
class MaladieInformationmaladie
{
    /**
     * @var string
     *
     * @ORM\Column(name="CODE", type="string", length=50, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $code;

    /**
     * @var integer
     *
     * @ORM\Column(name="STATE", type="smallint", nullable=true)
     */
    private $state;

    /**
     * @var \Application\Models\InformationMaladie
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\InformationMaladie")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="INFORMATIONMALADIE", referencedColumnName="CODE")
     * })
     */
    private $informationmaladie;

    /**
     * @var \Application\Models\Maladie
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Maladie")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="MALADIE", referencedColumnName="CODE")
     * })
     */
    private $maladie;



    /**
     * Get code
     *
     * @return string 
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set state
     *
     * @param integer $state
     * @return MaladieInformationmaladie
     */
    public function setState($state)
    {
        $this->state = $state;
    
        return $this;
    }

    /**
     * Get state
     *
     * @return integer 
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Set informationmaladie
     *
     * @param \Application\Models\InformationMaladie $informationmaladie
     * @return MaladieInformationmaladie
     */
    public function setInformationmaladie(\Application\Models\InformationMaladie $informationmaladie = null)
    {
        $this->informationmaladie = $informationmaladie;
    
        return $this;
    }

    /**
     * Get informationmaladie
     *
     * @return \Application\Models\InformationMaladie 
     */
    public function getInformationmaladie()
    {
        return $this->informationmaladie;
    }

    /**
     * Set maladie
     *
     * @param \Application\Models\Maladie $maladie
     * @return MaladieInformationmaladie
     */
    public function setMaladie(\Application\Models\Maladie $maladie = null)
    {
        $this->maladie = $maladie;
    
        return $this;
    }

    /**
     * Get maladie
     *
     * @return \Application\Models\Maladie 
     */
    public function getMaladie()
    {
        return $this->maladie;
    }
}