<?php

namespace Application\Models;

use Doctrine\ORM\Mapping as ORM;

/**
 * Echantillon
 *
 * @ORM\Table(name="echantillon")
 * @ORM\Entity
 */
class Echantillon
{
    /**
     * @var string
     *
     * @ORM\Column(name="CODE", type="string", length=50, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $code;

    /**
     * @var string
     *
     * @ORM\Column(name="NOMPRELEVEUR", type="string", length=50, nullable=true)
     */
    private $nompreleveur;

    /**
     * @var string
     *
     * @ORM\Column(name="CODEINLABO", type="string", length=50, nullable=true)
     */
    private $codeinlabo;

    /**
     * @var integer
     *
     * @ORM\Column(name="STATE", type="smallint", nullable=true)
     */
    private $state;

    /**
     * @var \Application\Models\Laboratoire
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Laboratoire")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="LABORATOIRE", referencedColumnName="CODE")
     * })
     */
    private $laboratoire;

    /**
     * @var \Application\Models\Site
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Site")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="SITE", referencedColumnName="CODE")
     * })
     */
    private $site;

    /**
     * @var \Application\Models\NatureEchantilon
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\NatureEchantilon")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="NATURE", referencedColumnName="CODE")
     * })
     */
    private $nature;

    /**
     * @var \Application\Models\TypeEchantillon
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\TypeEchantillon")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="TYPE", referencedColumnName="CODE")
     * })
     */
    private $type;



    /**
     * Get code
     *
     * @return string 
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set nompreleveur
     *
     * @param string $nompreleveur
     * @return Echantillon
     */
    public function setNompreleveur($nompreleveur)
    {
        $this->nompreleveur = $nompreleveur;
    
        return $this;
    }

    /**
     * Get nompreleveur
     *
     * @return string 
     */
    public function getNompreleveur()
    {
        return $this->nompreleveur;
    }

    /**
     * Set codeinlabo
     *
     * @param string $codeinlabo
     * @return Echantillon
     */
    public function setCodeinlabo($codeinlabo)
    {
        $this->codeinlabo = $codeinlabo;
    
        return $this;
    }

    /**
     * Get codeinlabo
     *
     * @return string 
     */
    public function getCodeinlabo()
    {
        return $this->codeinlabo;
    }

    /**
     * Set state
     *
     * @param integer $state
     * @return Echantillon
     */
    public function setState($state)
    {
        $this->state = $state;
    
        return $this;
    }

    /**
     * Get state
     *
     * @return integer 
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Set laboratoire
     *
     * @param \Application\Models\Laboratoire $laboratoire
     * @return Echantillon
     */
    public function setLaboratoire(\Application\Models\Laboratoire $laboratoire = null)
    {
        $this->laboratoire = $laboratoire;
    
        return $this;
    }

    /**
     * Get laboratoire
     *
     * @return \Application\Models\Laboratoire 
     */
    public function getLaboratoire()
    {
        return $this->laboratoire;
    }

    /**
     * Set site
     *
     * @param \Application\Models\Site $site
     * @return Echantillon
     */
    public function setSite(\Application\Models\Site $site = null)
    {
        $this->site = $site;
    
        return $this;
    }

    /**
     * Get site
     *
     * @return \Application\Models\Site 
     */
    public function getSite()
    {
        return $this->site;
    }

    /**
     * Set nature
     *
     * @param \Application\Models\NatureEchantilon $nature
     * @return Echantillon
     */
    public function setNature(\Application\Models\NatureEchantilon $nature = null)
    {
        $this->nature = $nature;
    
        return $this;
    }

    /**
     * Get nature
     *
     * @return \Application\Models\NatureEchantilon 
     */
    public function getNature()
    {
        return $this->nature;
    }

    /**
     * Set type
     *
     * @param \Application\Models\TypeEchantillon $type
     * @return Echantillon
     */
    public function setType(\Application\Models\TypeEchantillon $type = null)
    {
        $this->type = $type;
    
        return $this;
    }

    /**
     * Get type
     *
     * @return \Application\Models\TypeEchantillon 
     */
    public function getType()
    {
        return $this->type;
    }
}