<?php

namespace Application\Models;

use Doctrine\ORM\Mapping as ORM;

/**
 * EntreeConsommable
 *
 * @ORM\Table(name="fourniture")
 * @ORM\Entity
 */
class Fourniture
{
    /**
     * @var string
     *
     * @ORM\Column(name="id", type="bigint", length=50, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    

   

    /**
     * @var integer
     *
     * @ORM\Column(name="nom", type="string", length=100, nullable=true)
     */
    private $nom;

    /**
     * @var integer
     *
     * @ORM\Column(name="STATE", type="smallint", nullable=true)
     */
    private $state;
     /**
     * @var \DateTime
     *
     * @ORM\Column(name="datefourniture", type="datetime", nullable=true)
     */
    private $datefourniture;
   
    /**
     * @var \Application\Models\Utilisateur
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Utilisateur")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="receptioniste", referencedColumnName="CODE")
     * })
     */
    private $receptioniste;
    
     /**
     * @var \Application\Models\Emplacement
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Emplacement")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="emplacement", referencedColumnName="id")
     * })
     */
    private $emplacement;
 
    
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nom
     *
     * @param string $nom
     * @return Fourniture
     */
    public function setNom($nom)
    {
        $this->nom = $nom;
    
        return $this;
    }

    /**
     * Get nom
     *
     * @return string
     */
    public function getNom()
    {
        return $this->nom;
    }

    /**
     * Set datefourniture
     *
     * @param datetime $dateentree
     * @return EntreeConsommable
     */
    public function setDatefourniture($datefourniture)
    {
        $this->datefourniture = $datefourniture;
    
        return $this;
    }

    /**
     * Get datefourniture
     *
     * @return datetime 
     */
    public function getDatedatefourniture()
    {
        return $this->datefourniture;
    }

   

   

    /**
     * Set state
     *
     * @param integer $state
     * @return Authorisation
     */
    public function setState($state)
    {
        $this->state = $state;
    
        return $this;
    }

    

    /**
     * Get state
     *
     * @return integer 
     */
    public function getState()
    {
        return $this->state;
    }
      /**
     * Set Receptioniste
     *
     * @param \Application\Models\Utilisateur $user
     * @return EntreeConsommable
     */
    public function setReceptioniste(\Application\Models\Utilisateur $receptioniste = null)
    {
        
        $this->receptioniste = $receptioniste;
    
        return $this;
    }

    /**
     * Get Emplacement
     *
     * @return \Application\Models\Emplacement
     */
    public function getEmplacement()
    {
        return $this->emplacement;
    }
    
     /**
     * Set Emplacement
     *
     * @param \Application\Models\Emplacement $emplacement
     * @return Fourniture
     */
    public function setEmplacement(\Application\Models\Emplacement $emplacement = null)
    {
        
        $this->emplacement = $emplacement;
    
        return $this;
    }

    /**
     * Get Receptioniste
     *
     * @return \Application\Models\Receptioniste
     */
    public function getReceptioniste()
    {
        return $this->receptioniste;
    }
    
    
}