<?php

namespace Application\Models;

use Doctrine\ORM\Mapping as ORM;

/**
 * LaboratoireUtilisateur
 *
 * @ORM\Table(name="laboratoire_utilisateur")
 * @ORM\Entity
 */
class LaboratoireUtilisateur
{
    /**
     * @var string
     *
     * @ORM\Column(name="CODE", type="string", length=50, nullable=false)
     * @ORM\Id
     */
    private $code;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="DATEAFFECTATION", type="datetime", nullable=true)
     */
    private $dateaffectation;

    /**
     * @var integer
     *
     * @ORM\Column(name="STATE", type="smallint", nullable=true)
     */
    private $state;

    /**
     * @var \Application\Models\Laboratoire
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Laboratoire")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="LABORATOIRE", referencedColumnName="CODE")
     * })
     */
    private $laboratoire;

    /**
     * @var \Application\Models\Utilisateur
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Utilisateur")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="UTILISATEUR", referencedColumnName="CODE")
     * })
     */
    private $utilisateur;



    /**
     * Get code
     *
     * @return string 
     */
    public function getCode()
    {
        return $this->code;
    }
     /**
     * Set phone
     *
     * @param string $code
     * @return LaboratoireUtilisateur
     */
    public function setCode($code)
    {
        $this->code = $code;
    
        return $this;
    }
    /**
     * Set dateaffectation
     *
     * @param \DateTime $dateaffectation
     * @return LaboratoireUtilisateur
     */
    public function setDateaffectation($dateaffectation)
    {
        $this->dateaffectation = $dateaffectation;
    
        return $this;
    }

    /**
     * Get dateaffectation
     *
     * @return \DateTime 
     */
    public function getDateaffectation()
    {
        return $this->dateaffectation;
    }

    /**
     * Set state
     *
     * @param integer $state
     * @return LaboratoireUtilisateur
     */
    public function setState($state)
    {
        $this->state = $state;
    
        return $this;
    }

    /**
     * Get state
     *
     * @return integer 
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Set laboratoire
     *
     * @param \Application\Models\Laboratoire $laboratoire
     * @return LaboratoireUtilisateur
     */
    public function setLaboratoire(\Application\Models\Laboratoire $laboratoire = null)
    {
        $this->laboratoire = $laboratoire;
    
        return $this;
    }

    /**
     * Get laboratoire
     *
     * @return \Application\Models\Laboratoire 
     */
    public function getLaboratoire()
    {
        return $this->laboratoire;
    }

    /**
     * Set utilisateur
     *
     * @param \Application\Models\Utilisateur $utilisateur
     * @return LaboratoireUtilisateur
     */
    public function setUtilisateur(\Application\Models\Utilisateur $utilisateur = null)
    {
        $this->utilisateur = $utilisateur;
    
        return $this;
    }

    /**
     * Get utilisateur
     *
     * @return \Application\Models\Utilisateur 
     */
    public function getUtilisateur()
    {
        return $this->utilisateur;
    }
}