<?php

namespace Application\Models;

use Doctrine\ORM\Mapping as ORM;

/**
 * SiteUtilisateur
 *
 * @ORM\Table(name="site_utilisateur")
 * @ORM\Entity
 */
class SiteUtilisateur
{
    /**
     * @var string
     *
     * @ORM\Column(name="CODE", type="string", length=50, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $code;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="DATEAFFECTATION", type="datetime", nullable=true)
     */
    private $dateaffectation;

    /**
     * @var integer
     *
     * @ORM\Column(name="STATE", type="smallint", nullable=true)
     */
    private $state;

    /**
     * @var \Application\Models\Site
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Site")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="SITE", referencedColumnName="CODE")
     * })
     */
    private $site;

    /**
     * @var \Application\Models\Utilisateur
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Utilisateur")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="UTILISATEUR", referencedColumnName="CODE")
     * })
     */
    private $utilisateur;



    /**
     * Get code
     *
     * @return string 
     */
    public function getCode()
    {
        return $this->code;
    }
     /**
     * Set phone
     *
     * @param string $code
     * @return SiteUtilisateur
     */
    public function setCode($code)
    {
        $this->code = $code;
    
        return $this;
    }
    /**
     * Set dateaffectation
     *
     * @param \DateTime $dateaffectation
     * @return SiteUtilisateur
     */
    public function setDateaffectation($dateaffectation)
    {
        $this->dateaffectation = $dateaffectation;
    
        return $this;
    }

    /**
     * Get dateaffectation
     *
     * @return \DateTime 
     */
    public function getDateaffectation()
    {
        return $this->dateaffectation;
    }

    /**
     * Set state
     *
     * @param integer $state
     * @return SiteUtilisateur
     */
    public function setState($state)
    {
        $this->state = $state;
    
        return $this;
    }

    /**
     * Get state
     *
     * @return integer 
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Set site
     *
     * @param \Application\Models\Site $site
     * @return SiteUtilisateur
     */
    public function setSite(\Application\Models\Site $site = null)
    {
        $this->site = $site;
    
        return $this;
    }

    /**
     * Get site
     *
     * @return \Application\Models\Site 
     */
    public function getSite()
    {
        return $this->site;
    }

    /**
     * Set utilisateur
     *
     * @param \Application\Models\Utilisateur $utilisateur
     * @return SiteUtilisateur
     */
    public function setUtilisateur(\Application\Models\Utilisateur $utilisateur = null)
    {
        $this->utilisateur = $utilisateur;
    
        return $this;
    }

    /**
     * Get utilisateur
     *
     * @return \Application\Models\Utilisateur 
     */
    public function getUtilisateur()
    {
        return $this->utilisateur;
    }
}