<?php

namespace Application\Models;

use Doctrine\ORM\Mapping as ORM;

/**
 * SortieConsommable
 *
 * @ORM\Table(name="sortie")
 * @ORM\Entity
 */
class Sortie
{
   /**
     * @var string
     *
     * @ORM\Column(name="id", type="bigint", length=50, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;
    

   

    /**
     * @var integer
     *
     * @ORM\Column(name="nom", type="string", length=100, nullable=true)
     */
    private $nom;

    /**
     * @var integer
     *
     * @ORM\Column(name="STATE", type="smallint", nullable=true)
     */
    private $state;
     /**
     * @var \DateTime
     *
     * @ORM\Column(name="datesortie", type="datetime", nullable=true)
     */
    private $datesortie;
   
     /**
     * @var \Application\Models\Utilisateur
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Utilisateur")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="receptioniste", referencedColumnName="CODE")
     * })
     */
    private $receptioniste;
    
    /**
     * @var \Application\Models\Emplacement
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Emplacement")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="emplacement", referencedColumnName="id")
     * })
     */
    private $emplacement;
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nom
     *
     * @param string $nom
     * @return Sortie
     */
    public function setNom($nom)
    {
        $this->nom = $nom;
    
        return $this;
    }

    /**
     * Get nom
     *
     * @return string
     */
    public function getNom()
    {
        return $this->nom;
    }

    /**
     * Set datesortie
     *
     * @param datetime $datesortie
     * @return Sortie
     */
    public function setDatesortie($datesortie)
    {
        $this->datesortie = $datesortie;
    
        return $this;
    }

    /**
     * Get datesortie
     *
     * @return datetime 
     */
    public function getDatedatesortie()
    {
        return $this->datesortie;
    }

   

   

    /**
     * Set state
     *
     * @param integer $state
     * @return Authorisation
     */
    public function setState($state)
    {
        $this->state = $state;
    
        return $this;
    }

    

    /**
     * Get state
     *
     * @return integer 
     */
    public function getState()
    {
        return $this->state;
    }
     /**
     * Set Receptioniste
     *
     * @param \Application\Models\Utilisateur $user
     * @return EntreeConsommable
     */
    public function setReceptioniste(\Application\Models\Utilisateur $receptioniste = null)
    {
        
        $this->receptioniste = $receptioniste;
    
        return $this;
    }

    /**
     * Get Receptioniste
     *
     * @return \Application\Models\Receptioniste
     */
    public function getReceptioniste()
    {
        return $this->receptioniste;
    }
    
      /**
     * Get Emplacement
     *
     * @return \Application\Models\Emplacement
     */
    public function getEmplacement()
    {
        return $this->emplacement;
    }
    
     /**
     * Set Emplacement
     *
     * @param \Application\Models\Emplacement $emplacement
     * @return Fourniture
     */
    public function setEmplacement(\Application\Models\Emplacement $emplacement = null)
    {
        
        $this->emplacement = $emplacement;
    
        return $this;
    }
}