<?php

namespace Application\Models;

use Doctrine\ORM\Mapping as ORM;

/**
 * SortieConsommable
 *
 * @ORM\Table(name="sortieconsommable")
 * @ORM\Entity
 */
class SortieConsommable
{
    /**
     * @var string
     *
     * @ORM\Column(name="id", type="bigint", length=50, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    

   

    /**
     * @var integer
     *
     * @ORM\Column(name="quantite", type="bigint", length=50, nullable=true)
     */
    private $quantite;

    /**
     * @var integer
     *
     * @ORM\Column(name="STATE", type="smallint", nullable=true)
     */
    private $state;
     /**
     * @var \DateTime
     *
     * @ORM\Column(name="datesortie", type="datetime", nullable=true)
     */
    private $datesortie;
    /**
     * @var \Application\Models\Consommable
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Consommable")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="consommable", referencedColumnName="id")
     * })
     */
    private $consommable;
    /**
     * @var \Application\Models\Sortie
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Sortie")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="sortie", referencedColumnName="id")
     * })
     */
    private $sortie;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nombre
     *
     * @param string $nombre
     * @return SortieConsommable
     */
    public function setQuantite($qte)
    {
        $this->quantite = $qte;
    
        return $this;
    }

    /**
     * Get nombre
     *
     * @return integer 
     */
    public function getQuantite()
    {
        return $this->quantite;
    }

    /**
     * Set dateentree
     *
     * @param datetime $dateentree
     * @return SortieConsommable
     */
    public function setDatesortie($datesortie)
    {
        $this->datesortie = $datesortie;
    
        return $this;
    }

    /**
     * Get dateentree
     *
     * @return datetime 
     */
    public function getDatesortie()
    {
        return $this->datesortie;
    }

    /**
     * Set consommable
     *
     * @param \Application\Models\Consommable $consommable
     * @return SortieConsommable
     */
    public function setConsommable(\Application\Models\Consommable $consommable = null)
    {
        $this->consommable = $consommable;
    
        return $this;
    }

    /**
     * Get consommable
     *
     * @return \Application\Models\Consommable 
     */
    public function getConsommable()
    {
        return $this->consommable;
    }
    
    /**
     * Get sortie
     *
     * @return \Application\Models\Sortie 
     */
    public function getSortie()
    {
        return $this->sortie;
    }
    
    /**
     * Set sortie
     *
     * @param \Application\Models\Sortie $sortie
     * @return SortieConsommable
     */
    public function setSortie(\Application\Models\Sortie $sortie = null)
    {
        $this->sortie = $sortie;
    
        return $this;
    }
    /**
     * Set state
     *
     * @param integer $state
     * @return Authorisation
     */
    public function setState($state)
    {
        $this->state = $state;
    
        return $this;
    }

    

    /**
     * Get state
     *
     * @return integer 
     */
    public function getState()
    {
        return $this->state;
    }

}